/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.BeanByteSource;
import com.opengamma.strata.collect.io.BeanCharSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class UnicodeBom {
    private static final byte X_FE = -2;
    private static final byte X_EF = -17;
    private static final byte X_FF = -1;
    private static final byte X_BF = -65;
    private static final byte X_BB = -69;

    private UnicodeBom() {
    }

    public static String toString(byte[] input) {
        if (input.length >= 3 && input[0] == -17 && input[1] == -69 && input[2] == -65) {
            return new String(input, 3, input.length - 3, StandardCharsets.UTF_8);
        }
        if (input.length >= 2 && input[0] == -2 && input[1] == -1) {
            return new String(input, 2, input.length - 2, StandardCharsets.UTF_16BE);
        }
        if (input.length >= 2 && input[0] == -1 && input[1] == -2) {
            return new String(input, 2, input.length - 2, StandardCharsets.UTF_16LE);
        }
        return new String(input, StandardCharsets.UTF_8);
    }

    public static CharSource toCharSource(final ByteSource byteSource) {
        return new CharSource(){

            public Reader openStream() throws IOException {
                return UnicodeBom.toReader(byteSource.openStream());
            }

            public String toString() {
                return "UnicodeBom.toCharSource(" + byteSource.toString() + ")";
            }
        };
    }

    public static BeanCharSource toCharSource(BeanByteSource byteSource) {
        return new UnicodeBomCharSource(byteSource);
    }

    public static Reader toReader(InputStream inputStream) throws IOException {
        return new BomReader(inputStream);
    }

    static class UnicodeBomCharSource
    extends BeanCharSource {
        private final BeanByteSource underlying;

        UnicodeBomCharSource(BeanByteSource underlying) {
            this.underlying = ArgChecker.notNull(underlying, "underlying");
        }

        public MetaBean metaBean() {
            return Meta.META;
        }

        @Override
        public Optional<String> getFileName() {
            return this.underlying.getFileName();
        }

        public Reader openStream() throws IOException {
            return UnicodeBom.toReader(this.underlying.openStream());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == ((Object)((Object)this)).getClass()) {
                UnicodeBomCharSource other = (UnicodeBomCharSource)((Object)obj);
                return JodaBeanUtils.equal((Object)((Object)this.underlying), (Object)((Object)other.underlying));
            }
            return false;
        }

        public int hashCode() {
            int hash = ((Object)((Object)this)).getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.underlying));
            return hash;
        }

        public String toString() {
            return "UnicodeBom.toCharSource(" + ((Object)((Object)this.underlying)).toString() + ")";
        }

        static {
            MetaBean.register((MetaBean)Meta.META);
        }

        static final class Meta
        extends BasicMetaBean {
            private static final MetaBean META = new Meta();
            private static final MetaProperty<BeanByteSource> UNDERLYING = new BasicMetaProperty<BeanByteSource>("underlying"){

                public MetaBean metaBean() {
                    return META;
                }

                public Class<?> declaringType() {
                    return UnicodeBomCharSource.class;
                }

                public Class<BeanByteSource> propertyType() {
                    return BeanByteSource.class;
                }

                public Type propertyGenericType() {
                    return BeanByteSource.class;
                }

                public PropertyStyle style() {
                    return PropertyStyle.IMMUTABLE;
                }

                public List<Annotation> annotations() {
                    return ImmutableList.of();
                }

                public BeanByteSource get(Bean bean) {
                    return ((UnicodeBomCharSource)bean).underlying;
                }

                public void set(Bean bean, Object value) {
                    throw new UnsupportedOperationException("Property cannot be written: " + this.name());
                }
            };
            private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"underlying", UNDERLYING);

            private Meta() {
            }

            public boolean isBuildable() {
                return true;
            }

            public BeanBuilder<UnicodeBomCharSource> builder() {
                return new BasicImmutableBeanBuilder<UnicodeBomCharSource>((MetaBean)this){
                    private BeanByteSource underlying;

                    public Object get(String propertyName) {
                        if (propertyName.equals(UNDERLYING.name())) {
                            return this.underlying;
                        }
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }

                    public BeanBuilder<UnicodeBomCharSource> set(String propertyName, Object value) {
                        if (!propertyName.equals(UNDERLYING.name())) {
                            throw new NoSuchElementException("Unknown property: " + propertyName);
                        }
                        this.underlying = (BeanByteSource)((Object)ArgChecker.notNull(value, "underlying"));
                        return this;
                    }

                    public UnicodeBomCharSource build() {
                        ArgChecker.notNull(this.underlying, "underlying");
                        return new UnicodeBomCharSource(this.underlying);
                    }
                };
            }

            public Class<? extends Bean> beanType() {
                return UnicodeBomCharSource.class;
            }

            public Map<String, MetaProperty<?>> metaPropertyMap() {
                return MAP;
            }
        }
    }

    private static final class BomReader
    extends Reader {
        private static final int MAX_BOM_SIZE = 4;
        private final InputStreamReader underlying;

        BomReader(InputStream inputStream) throws IOException {
            super(inputStream);
            Charset encoding;
            byte[] bom = new byte[4];
            PushbackInputStream pushbackStream = new PushbackInputStream(inputStream, 4);
            int bytesRead = ByteStreams.read((InputStream)pushbackStream, (byte[])bom, (int)0, (int)3);
            if (bytesRead >= 3 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                encoding = StandardCharsets.UTF_8;
                pushbackStream.unread(bom, 3, bytesRead - 3);
            } else if (bytesRead >= 2 && bom[0] == -2 && bom[1] == -1) {
                encoding = StandardCharsets.UTF_16BE;
                pushbackStream.unread(bom, 2, bytesRead - 2);
            } else if (bytesRead >= 2 && bom[0] == -1 && bom[1] == -2) {
                encoding = StandardCharsets.UTF_16LE;
                pushbackStream.unread(bom, 2, bytesRead - 2);
            } else {
                encoding = StandardCharsets.UTF_8;
                pushbackStream.unread(bom, 0, bytesRead);
            }
            this.underlying = new InputStreamReader((InputStream)pushbackStream, encoding);
        }

        @Override
        public int read(CharBuffer target) throws IOException {
            return this.underlying.read(target);
        }

        @Override
        public int read() throws IOException {
            return this.underlying.read();
        }

        @Override
        public int read(char[] cbuf) throws IOException {
            return this.underlying.read(cbuf);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return this.underlying.read(cbuf, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.underlying.skip(n);
        }

        @Override
        public boolean ready() throws IOException {
            return this.underlying.ready();
        }

        @Override
        public boolean markSupported() {
            return this.underlying.markSupported();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.underlying.mark(readAheadLimit);
        }

        @Override
        public void reset() throws IOException {
            this.underlying.reset();
        }

        @Override
        public void close() throws IOException {
            this.underlying.close();
        }
    }
}

