/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.named;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import java.util.EnumMap;
import java.util.Locale;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class EnumNames<T extends Enum<T>> {
    private final ImmutableSortedMap<String, T> parseMap;
    private final ImmutableSortedSet<String> formattedSet;
    private final EnumMap<T, String> formatMap;
    private final Class<T> enumType;

    public static <T extends Enum<T>> EnumNames<T> of(Class<T> enumType) {
        return new EnumNames<T>(enumType, false);
    }

    public static <T extends Enum<T>> EnumNames<T> ofManualToString(Class<T> enumType) {
        return new EnumNames<T>(enumType, true);
    }

    private EnumNames(Class<T> enumType, boolean manualToString) {
        this.enumType = ArgChecker.notNull(enumType, "enumType");
        TreeMap<String, Enum> parseMap = new TreeMap<String, Enum>();
        TreeSet<String> formattedSet = new TreeSet<String>();
        EnumMap<T, String> formatMap = new EnumMap<T, String>(enumType);
        for (Enum value : (Enum[])enumType.getEnumConstants()) {
            String formatted = manualToString ? value.toString() : CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, value.name());
            parseMap.put(value.name(), value);
            parseMap.put(value.name().toUpperCase(Locale.ENGLISH), value);
            parseMap.put(value.name().toLowerCase(Locale.ENGLISH), value);
            parseMap.put(formatted, value);
            parseMap.put(formatted.toUpperCase(Locale.ENGLISH), value);
            parseMap.put(formatted.toLowerCase(Locale.ENGLISH), value);
            formattedSet.add(formatted);
            formatMap.put(value, formatted);
        }
        this.parseMap = ImmutableSortedMap.copyOf(parseMap);
        this.formattedSet = ImmutableSortedSet.copyOf(formattedSet);
        this.formatMap = formatMap;
    }

    private EnumNames(Class<T> enumType, SortedMap<String, T> parseMap, SortedSet<String> formattedSet, EnumMap<T, String> formatMap) {
        this.enumType = enumType;
        this.parseMap = ImmutableSortedMap.copyOf(parseMap);
        this.formattedSet = ImmutableSortedSet.copyOf(formattedSet);
        this.formatMap = formatMap;
    }

    public EnumNames<T> withParseAlias(String alias, T value) {
        TreeMap<String, T> parseMap = new TreeMap<String, T>(this.parseMap);
        TreeSet<String> formattedSet = new TreeSet<String>((SortedSet<String>)this.formattedSet);
        parseMap.put(alias, value);
        parseMap.put(alias.toUpperCase(Locale.ENGLISH), value);
        parseMap.put(alias.toLowerCase(Locale.ENGLISH), value);
        formattedSet.add(alias);
        return new EnumNames<T>(this.enumType, parseMap, formattedSet, this.formatMap);
    }

    public String format(T value) {
        return this.formatMap.get(value);
    }

    public T parse(String name) {
        ArgChecker.notNull(name, "name");
        Enum value = (Enum)this.parseMap.get((Object)name);
        if (value == null) {
            throw new IllegalArgumentException(Messages.format("Unknown enum name '{}' for type {}, valid values are {}", name, this.enumType.getName(), this.formattedSet));
        }
        return (T)value;
    }
}

