/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.result;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.result.FailureItem;
import com.opengamma.strata.collect.result.Result;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ValueWithFailures<T>
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final T value;
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<FailureItem> failures;
    private static final long serialVersionUID = 1L;

    public static <T> ValueWithFailures<T> of(T successValue, FailureItem ... failures) {
        return new ValueWithFailures<T>(successValue, (List<FailureItem>)ImmutableList.copyOf((Object[])failures));
    }

    public static <T> ValueWithFailures<T> of(T successValue, List<FailureItem> failures) {
        return new ValueWithFailures<T>(successValue, failures);
    }

    public static <T> ValueWithFailures<T> of(T successValue, Collection<FailureItem> failures) {
        return new ValueWithFailures<T>(successValue, (List<FailureItem>)ImmutableList.copyOf(failures));
    }

    public static <T> ValueWithFailures<T> of(T emptyValue, Supplier<T> supplier) {
        try {
            return ValueWithFailures.of(supplier.get(), new FailureItem[0]);
        }
        catch (Exception ex) {
            return ValueWithFailures.of(emptyValue, FailureItem.from(ex));
        }
    }

    public static <T> BinaryOperator<ValueWithFailures<T>> combiningValues(BinaryOperator<T> combiner) {
        ArgChecker.notNull(combiner, "combiner");
        return (vwf1, vwf2) -> vwf1.combinedWith((ValueWithFailures)vwf2, combiner);
    }

    public static <T> Collector<ValueWithFailures<T>, ?, ValueWithFailures<T>> toValueWithFailures(T identityValue, BinaryOperator<T> operator) {
        return Collectors.reducing(ValueWithFailures.of(identityValue, new FailureItem[0]), ValueWithFailures.combiningValues(operator));
    }

    public static <T> Collector<ValueWithFailures<? extends T>, ?, ValueWithFailures<List<T>>> toCombinedValuesAsList() {
        return Collector.of(() -> new StreamBuilder((ImmutableCollection.Builder)ImmutableList.builder(), null), (A rec$, T x$0) -> ((StreamBuilder)rec$).add(x$0), (rec$, x$0) -> ((StreamBuilder)rec$).combine((StreamBuilder)x$0), (A rec$) -> ((StreamBuilder)rec$).build(), new Collector.Characteristics[0]);
    }

    public static <T> Collector<ValueWithFailures<? extends T>, ?, ValueWithFailures<Set<T>>> toCombinedValuesAsSet() {
        return Collector.of(() -> new StreamBuilder((ImmutableCollection.Builder)ImmutableSet.builder(), null), (A rec$, T x$0) -> ((StreamBuilder)rec$).add(x$0), (rec$, x$0) -> ((StreamBuilder)rec$).combine((StreamBuilder)x$0), (A rec$) -> ((StreamBuilder)rec$).build(), new Collector.Characteristics[0]);
    }

    public static <T> Collector<Result<? extends T>, ?, ValueWithFailures<List<T>>> toCombinedResultsAsList() {
        return Collector.of(() -> new StreamBuilder((ImmutableCollection.Builder)ImmutableList.builder(), null), (A rec$, T x$0) -> ((StreamBuilder)rec$).addResult(x$0), (rec$, x$0) -> ((StreamBuilder)rec$).combine((StreamBuilder)x$0), (A rec$) -> ((StreamBuilder)rec$).build(), new Collector.Characteristics[0]);
    }

    public static <T> ValueWithFailures<List<T>> combineValuesAsList(Iterable<? extends ValueWithFailures<? extends T>> items) {
        ImmutableList.Builder values = ImmutableList.builder();
        ImmutableList<FailureItem> failures = ValueWithFailures.combine(items, values);
        return ValueWithFailures.of(values.build(), failures);
    }

    public static <T> ValueWithFailures<Set<T>> combineValuesAsSet(Iterable<? extends ValueWithFailures<? extends T>> items) {
        ImmutableSet.Builder values = ImmutableSet.builder();
        ImmutableList<FailureItem> failures = ValueWithFailures.combine(items, values);
        return ValueWithFailures.of(values.build(), failures);
    }

    private static <T> ImmutableList<FailureItem> combine(Iterable<? extends ValueWithFailures<? extends T>> items, ImmutableCollection.Builder<T> values) {
        ImmutableList.Builder failures = ImmutableList.builder();
        for (ValueWithFailures<T> item : items) {
            values.add(item.getValue());
            failures.addAll(item.getFailures());
        }
        return failures.build();
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    public <R> ValueWithFailures<R> map(Function<? super T, ? extends R> function) {
        R transformedValue = Objects.requireNonNull(function.apply(this.value));
        return ValueWithFailures.of(transformedValue, this.failures);
    }

    public ValueWithFailures<T> mapFailures(Function<FailureItem, FailureItem> function) {
        if (this.failures.isEmpty()) {
            return this;
        }
        return ValueWithFailures.of(this.value, (List)this.failures.stream().map(function).collect(Guavate.toImmutableList()));
    }

    public <R> ValueWithFailures<R> flatMap(Function<? super T, ValueWithFailures<R>> function) {
        ValueWithFailures<R> transformedValue = Objects.requireNonNull(function.apply(this.value));
        ImmutableList combinedFailures = Guavate.concatToList(new Iterable[]{this.failures, transformedValue.failures});
        return ValueWithFailures.of(transformedValue.value, combinedFailures);
    }

    public <U, R> ValueWithFailures<R> combinedWith(ValueWithFailures<U> other, BiFunction<T, U, R> combiner) {
        R combinedValue = Objects.requireNonNull(combiner.apply(this.value, other.value));
        ImmutableList combinedFailures = Guavate.concatToList(new Iterable[]{this.failures, other.failures});
        return ValueWithFailures.of(combinedValue, combinedFailures);
    }

    public <R> ValueWithFailures<R> withValue(R value) {
        return ValueWithFailures.of(value, this.failures);
    }

    public <R> ValueWithFailures<R> withValue(R value, List<FailureItem> additionalFailures) {
        return ValueWithFailures.of(value, Guavate.concatToList(new Iterable[]{this.failures, additionalFailures}));
    }

    public <R> ValueWithFailures<R> withValue(ValueWithFailures<R> valueWithFailures) {
        return ValueWithFailures.of(valueWithFailures.getValue(), Guavate.concatToList(new Iterable[]{this.failures, valueWithFailures.getFailures()}));
    }

    public ValueWithFailures<T> withAdditionalFailures(List<FailureItem> additionalFailures) {
        return ValueWithFailures.of(this.value, Guavate.concatToList(new Iterable[]{this.failures, additionalFailures}));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaValueWithFailures(Class<R> cls) {
        return Meta.INSTANCE;
    }

    private ValueWithFailures(T value, List<FailureItem> failures) {
        JodaBeanUtils.notNull(value, (String)"value");
        JodaBeanUtils.notNull(failures, (String)"failures");
        this.value = value;
        this.failures = ImmutableList.copyOf(failures);
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public T getValue() {
        return this.value;
    }

    public ImmutableList<FailureItem> getFailures() {
        return this.failures;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ValueWithFailures other = (ValueWithFailures)obj;
            return JodaBeanUtils.equal(this.value, other.value) && JodaBeanUtils.equal(this.failures, other.failures);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.failures);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ValueWithFailures{");
        buf.append("value").append('=').append(JodaBeanUtils.toString(this.value)).append(',').append(' ');
        buf.append("failures").append('=').append(JodaBeanUtils.toString(this.failures));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<T>
    extends DirectPrivateBeanBuilder<ValueWithFailures<T>> {
        private T value;
        private List<FailureItem> failures = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 675938345: {
                    return this.failures;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = newValue;
                    break;
                }
                case 675938345: {
                    this.failures = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ValueWithFailures<T> build() {
            return new ValueWithFailures(this.value, this.failures);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ValueWithFailures.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString(this.value)).append(',').append(' ');
            buf.append("failures").append('=').append(JodaBeanUtils.toString(this.failures));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<T> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", ValueWithFailures.class, Object.class);
        private final MetaProperty<ImmutableList<FailureItem>> failures = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"failures", ValueWithFailures.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value", "failures"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
                case 675938345: {
                    return this.failures;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ValueWithFailures<T>> builder() {
            return new Builder();
        }

        public Class<? extends ValueWithFailures<T>> beanType() {
            return ValueWithFailures.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<T> value() {
            return this.value;
        }

        public MetaProperty<ImmutableList<FailureItem>> failures() {
            return this.failures;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((ValueWithFailures)bean).getValue();
                }
                case 675938345: {
                    return ((ValueWithFailures)bean).getFailures();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }

    private static final class StreamBuilder<T, B extends ImmutableCollection.Builder<T>> {
        private final B values;
        private final ImmutableList.Builder<FailureItem> failures = ImmutableList.builder();

        private StreamBuilder(B values) {
            this.values = values;
        }

        private void add(ValueWithFailures<? extends T> item) {
            this.values.add(item.getValue());
            this.failures.addAll(item.getFailures());
        }

        private void addResult(Result<? extends T> item) {
            item.ifSuccess(value -> this.values.add(value));
            item.ifFailure(failure -> this.failures.addAll(failure.getItems()));
        }

        private StreamBuilder<T, B> combine(StreamBuilder<T, B> builder) {
            this.values.addAll((Iterable)builder.values.build());
            this.failures.addAll((Iterable)builder.failures.build());
            return this;
        }

        private <C extends Collection<T>> ValueWithFailures<C> build() {
            return ValueWithFailures.of(this.values.build(), (List<FailureItem>)this.failures.build());
        }

        /* synthetic */ StreamBuilder(ImmutableCollection.Builder x0, 1 x1) {
            this(x0);
        }
    }
}

