/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.timeseries;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.timeseries.DenseLocalDateDoubleTimeSeries;
import com.opengamma.strata.collect.timeseries.LocalDateDoublePoint;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.collect.timeseries.SparseLocalDateDoubleTimeSeries;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.DoubleBinaryOperator;
import java.util.stream.Stream;

public final class LocalDateDoubleTimeSeriesBuilder {
    private static final double DENSITY_THRESHOLD = 0.7;
    private final SortedMap<LocalDate, Double> entries = new TreeMap<LocalDate, Double>();
    private boolean containsWeekends;

    LocalDateDoubleTimeSeriesBuilder() {
    }

    LocalDateDoubleTimeSeriesBuilder(LocalDate[] dates, double[] values) {
        for (int i = 0; i < dates.length; ++i) {
            this.put(dates[i], values[i]);
        }
    }

    LocalDateDoubleTimeSeriesBuilder(Stream<LocalDateDoublePoint> points) {
        points.forEach(pt -> this.put(pt.getDate(), pt.getValue()));
    }

    public OptionalDouble get(LocalDate date) {
        Double value = (Double)this.entries.get(date);
        return value != null ? OptionalDouble.of(value) : OptionalDouble.empty();
    }

    public LocalDateDoubleTimeSeriesBuilder put(LocalDate date, double value) {
        ArgChecker.notNull(date, "date");
        ArgChecker.isFalse(Double.isNaN(value), "NaN is not allowed as a value");
        this.entries.put(date, value);
        this.updateWeekendFlag(date);
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder put(LocalDateDoublePoint point) {
        ArgChecker.notNull(point, "point");
        this.put(point.getDate(), point.getValue());
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder merge(LocalDate date, double value, DoubleBinaryOperator operator) {
        ArgChecker.notNull(date, "date");
        ArgChecker.notNull(operator, "operator");
        this.entries.merge(date, value, (? super V a, ? super V b) -> operator.applyAsDouble((double)a, (double)b));
        this.updateWeekendFlag(date);
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder merge(LocalDateDoublePoint point, DoubleBinaryOperator operator) {
        ArgChecker.notNull(point, "point");
        return this.merge(point.getDate(), point.getValue(), operator);
    }

    private void updateWeekendFlag(LocalDate date) {
        if (!this.containsWeekends && date.get(ChronoField.DAY_OF_WEEK) > 5) {
            this.containsWeekends = true;
        }
    }

    public LocalDateDoubleTimeSeriesBuilder putAll(Collection<LocalDate> dates, Collection<Double> values) {
        ArgChecker.noNulls(dates, "dates");
        ArgChecker.noNulls(values, "values");
        ArgChecker.isTrue(dates.size() == values.size(), "Arrays are of different sizes - dates: {}, values: {}", dates.size(), values.size());
        Iterator<LocalDate> itDate = dates.iterator();
        Iterator<Double> itValue = values.iterator();
        for (int i = 0; i < dates.size(); ++i) {
            this.put(itDate.next(), itValue.next());
        }
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder putAll(Collection<LocalDate> dates, double[] values) {
        ArgChecker.noNulls(dates, "dates");
        ArgChecker.notNull(values, "values");
        ArgChecker.isTrue(dates.size() == values.length, "Arrays are of different sizes - dates: {}, values: {}", dates.size(), values.length);
        Iterator<LocalDate> itDate = dates.iterator();
        for (int i = 0; i < dates.size(); ++i) {
            this.put(itDate.next(), values[i]);
        }
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder putAll(Stream<LocalDateDoublePoint> points) {
        ArgChecker.notNull(points, "points");
        points.forEach(this::put);
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder putAll(List<LocalDateDoublePoint> points) {
        ArgChecker.notNull(points, "points");
        return this.putAll(points.stream());
    }

    public LocalDateDoubleTimeSeriesBuilder putAll(LocalDateDoubleTimeSeriesBuilder other) {
        ArgChecker.notNull(other, "other");
        this.entries.putAll(other.entries);
        this.containsWeekends = this.containsWeekends || other.containsWeekends;
        return this;
    }

    public LocalDateDoubleTimeSeriesBuilder putAll(Map<LocalDate, Double> map) {
        ArgChecker.noNulls(map, "map");
        map.entrySet().forEach(e -> this.put((LocalDate)e.getKey(), (Double)e.getValue()));
        return this;
    }

    public LocalDateDoubleTimeSeries build() {
        if (this.entries.isEmpty()) {
            return LocalDateDoubleTimeSeries.empty();
        }
        return this.density() > 0.7 ? this.createDenseSeries() : this.createSparseSeries();
    }

    private LocalDateDoubleTimeSeries createDenseSeries() {
        return DenseLocalDateDoubleTimeSeries.of(this.entries.firstKey(), this.entries.lastKey(), this.streamEntries(), this.determineCalculation());
    }

    private SparseLocalDateDoubleTimeSeries createSparseSeries() {
        return SparseLocalDateDoubleTimeSeries.of(this.entries.keySet(), this.entries.values());
    }

    private Stream<LocalDateDoublePoint> streamEntries() {
        return this.entries.entrySet().stream().map(e -> LocalDateDoublePoint.of((LocalDate)e.getKey(), (Double)e.getValue()));
    }

    private DenseLocalDateDoubleTimeSeries.DenseTimeSeriesCalculation determineCalculation() {
        return this.containsWeekends ? DenseLocalDateDoubleTimeSeries.DenseTimeSeriesCalculation.INCLUDE_WEEKENDS : DenseLocalDateDoubleTimeSeries.DenseTimeSeriesCalculation.SKIP_WEEKENDS;
    }

    private double density() {
        double rangeSize = this.determineCalculation().calculatePosition(this.entries.firstKey(), this.entries.lastKey()) + 1;
        return (double)this.entries.size() / rangeSize;
    }
}

