/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.opengamma.strata.collect.Guavate;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public final class SafeFiles {
    private SafeFiles() {
    }

    public static List<Path> listAll(Path dir) {
        return (List)SafeFiles.list(dir, stream -> stream.collect(Guavate.toImmutableList()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T list(Path dir, Function<Stream<Path>, T> function) {
        try (Stream<Path> stream = Files.list(dir);){
            Stream<Path> stream2 = function.apply(stream);
            return (T)stream2;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static List<Path> walkAll(Path dir) {
        return (List)SafeFiles.walk(dir, Integer.MAX_VALUE, stream -> stream.collect(Guavate.toImmutableList()), new FileVisitOption[0]);
    }

    public static List<Path> walkAll(Path dir, int maxDepth, FileVisitOption ... options) {
        return (List)SafeFiles.walk(dir, maxDepth, stream -> stream.collect(Guavate.toImmutableList()), options);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T walk(Path dir, int maxDepth, Function<Stream<Path>, T> function, FileVisitOption ... options) {
        try (Stream<Path> stream = Files.walk(dir, maxDepth, options);){
            Stream<Path> stream2 = function.apply(stream);
            return (T)stream2;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static List<String> linesAll(Path file) {
        return (List)SafeFiles.lines(file, stream -> stream.collect(Guavate.toImmutableList()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T lines(Path file, Function<Stream<String>, T> function) {
        try (Stream<String> stream = Files.lines(file);){
            Stream<String> stream2 = function.apply(stream);
            return (T)stream2;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

