/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.function.CheckedSupplier;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.BeanCharSource;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class StringCharSource
extends BeanCharSource
implements ImmutableBean,
Serializable {
    public static final StringCharSource EMPTY = new StringCharSource("");
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String fileName;

    public static StringCharSource of(String str) {
        return new StringCharSource(str);
    }

    public static StringCharSource fromBytesUtf8(byte[] bytes) {
        return StringCharSource.fromBytes(bytes, StandardCharsets.UTF_8);
    }

    public static StringCharSource fromBytes(byte[] bytes, Charset charset) {
        return new StringCharSource(new String(bytes, charset));
    }

    public static StringCharSource from(CharSource other) {
        if (other instanceof StringCharSource) {
            return (StringCharSource)other;
        }
        String fileName = null;
        if (other instanceof BeanCharSource) {
            fileName = ((BeanCharSource)other).getFileName().orElse(null);
        } else {
            String str = other.toString();
            if (str.equals("CharSource.empty()")) {
                return EMPTY;
            }
            if (str.startsWith("Files.asByteSource(")) {
                int pos = str.indexOf(41, 19);
                fileName = Paths.get(str.substring(19, pos), new String[0]).getFileName().toString();
            } else if (str.startsWith("MoreFiles.asByteSource(")) {
                int pos = str.indexOf(44, 23);
                fileName = Paths.get(str.substring(23, pos), new String[0]).getFileName().toString();
            } else if (str.startsWith("Resources.asByteSource(")) {
                int pos = str.indexOf(41, 23);
                String path = str.substring(23, pos);
                int lastSlash = path.lastIndexOf(47);
                fileName = path.substring(lastSlash + 1);
            }
        }
        return new StringCharSource(Unchecked.wrap(() -> other.read()), fileName);
    }

    public static StringCharSource from(CheckedSupplier<? extends Reader> readerSupplier) {
        return Unchecked.wrap(() -> {
            try (Reader in = (Reader)readerSupplier.get();){
                StringCharSource stringCharSource = StringCharSource.from(in);
                return stringCharSource;
            }
        });
    }

    public static StringCharSource from(Readable reader) throws IOException {
        String chars = CharStreams.toString((Readable)reader);
        return new StringCharSource(chars);
    }

    private StringCharSource(String value) {
        this.value = value;
        this.fileName = null;
    }

    StringCharSource(String value, String fileName) {
        this.value = value;
        this.fileName = Strings.emptyToNull((String)fileName);
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    @Override
    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public StringCharSource withFileName(String fileName) {
        ArgChecker.notNull(fileName, "fileName");
        int lastSlash = fileName.lastIndexOf(47);
        return new StringCharSource(this.value, fileName.substring(lastSlash + 1));
    }

    public Reader openStream() {
        return new StringReader(this.value);
    }

    @Override
    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public com.google.common.base.Optional<Long> lengthIfKnown() {
        return com.google.common.base.Optional.of((Object)this.length());
    }

    @Override
    public long length() {
        return this.value.length();
    }

    public long copyTo(Appendable appendable) throws IOException {
        appendable.append(this.value);
        return this.value.length();
    }

    public long copyTo(CharSink sink) throws IOException {
        sink.write((CharSequence)this.value);
        return this.value.length();
    }

    @Override
    public String read() {
        return this.value;
    }

    @Override
    public StringCharSource load() {
        return this;
    }

    @Override
    public ArrayByteSource asByteSourceUtf8() {
        return this.asByteSource(StandardCharsets.UTF_8);
    }

    @Override
    public ArrayByteSource asByteSource(Charset charset) {
        return new ArrayByteSource(this.value.getBytes(charset), this.fileName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            StringCharSource other = (StringCharSource)obj;
            return JodaBeanUtils.equal((Object)this.fileName, (Object)other.fileName) && JodaBeanUtils.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fileName);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.value);
        return hash;
    }

    public String toString() {
        return "StringCharSource[" + this.length() + " chars" + (this.fileName != null ? ", " + this.fileName : "") + "]";
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<String> VALUE = new BasicMetaProperty<String>("value"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return StringCharSource.class;
            }

            public Class<String> propertyType() {
                return String.class;
            }

            public Type propertyGenericType() {
                return String.class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public String get(Bean bean) {
                return ((StringCharSource)bean).value;
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final MetaProperty<String> FILE_NAME = new BasicMetaProperty<String>("fileName"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return StringCharSource.class;
            }

            public Class<String> propertyType() {
                return String.class;
            }

            public Type propertyGenericType() {
                return String.class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public String get(Bean bean) {
                return ((StringCharSource)bean).fileName;
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"value", VALUE, (Object)"fileName", FILE_NAME);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<StringCharSource> builder() {
            return new BasicImmutableBeanBuilder<StringCharSource>((MetaBean)this){
                private String value;
                private String fileName;

                public Object get(String propertyName) {
                    if (propertyName.equals(VALUE.name())) {
                        return this.value;
                    }
                    if (propertyName.equals(FILE_NAME.name())) {
                        return this.fileName;
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<StringCharSource> set(String propertyName, Object value) {
                    if (propertyName.equals(VALUE.name())) {
                        this.value = (String)ArgChecker.notNull(value, "value");
                    } else if (propertyName.equals(FILE_NAME.name())) {
                        this.fileName = (String)value;
                    } else {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    return this;
                }

                public StringCharSource build() {
                    ArgChecker.notNull(this.value, "value");
                    return new StringCharSource(this.value, this.fileName);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return StringCharSource.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }
}

