/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.base.CharMatcher;

public final class CharMatchers {
    private static final CharMatcher UPPER_LETTERS = CharMatcher.inRange((char)'A', (char)'Z');
    private static final CharMatcher LOWER_LETTERS = CharMatcher.inRange((char)'a', (char)'z');
    private static final CharMatcher LETTERS = UPPER_LETTERS.or(LOWER_LETTERS);
    private static final CharMatcher DIGITS = CharMatcher.inRange((char)'0', (char)'9');
    private static final CharMatcher LETTERS_DIGITS = LETTERS.or(DIGITS);
    private static final CharMatcher UPPER_HEX = DIGITS.or(CharMatcher.inRange((char)'A', (char)'F'));
    private static final CharMatcher LOWER_HEX = DIGITS.or(CharMatcher.inRange((char)'a', (char)'f'));
    private static final CharMatcher HEX = UPPER_HEX.or(LOWER_HEX);

    private CharMatchers() {
    }

    public static CharMatcher upperLetters() {
        return UPPER_LETTERS;
    }

    public static CharMatcher lowerLetters() {
        return LOWER_LETTERS;
    }

    public static CharMatcher letters() {
        return LETTERS;
    }

    public static CharMatcher digits() {
        return DIGITS;
    }

    public static CharMatcher lettersAndDigits() {
        return LETTERS_DIGITS;
    }

    public static CharMatcher upperHex() {
        return UPPER_HEX;
    }

    public static CharMatcher lowerHex() {
        return LOWER_HEX;
    }

    public static CharMatcher hex() {
        return HEX;
    }
}

