/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.BasisPoints;
import com.opengamma.strata.collect.Decimal;
import java.math.RoundingMode;
import java.util.function.UnaryOperator;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Percentage
implements Comparable<Percentage> {
    public static final Percentage ZERO = new Percentage(Decimal.ZERO);
    private static final int MAX_SCALE = 10;
    private final Decimal amount;

    public static Percentage of(double percentage) {
        return Percentage.of(Decimal.of(percentage));
    }

    public static Percentage of(Decimal percentage) {
        return new Percentage(percentage);
    }

    public static Percentage fromDecimalForm(double decimal) {
        return Percentage.fromDecimalForm(Decimal.of(decimal));
    }

    public static Percentage fromDecimalForm(Decimal decimal) {
        return Percentage.of(decimal.movePoint(2));
    }

    public static Percentage fromBasisPoints(BasisPoints basisPoints) {
        return Percentage.of(basisPoints.valueBasisPoints().movePoint(-2));
    }

    @FromString
    public static Percentage parse(String str) {
        ArgChecker.notNull(str, "str");
        if (str.endsWith("%")) {
            return Percentage.of(Decimal.of(str.substring(0, str.length() - 1).trim()));
        }
        if (str.endsWith("pct")) {
            return Percentage.of(Decimal.of(str.substring(0, str.length() - 3).trim()));
        }
        return Percentage.of(Decimal.of(str.trim()));
    }

    private Percentage(Decimal percentage) {
        ArgChecker.notNull(percentage, "percentage");
        this.amount = percentage.roundToScale(10, RoundingMode.HALF_UP);
    }

    public Decimal valuePercent() {
        return this.amount;
    }

    public Decimal toDecimalForm() {
        return this.amount.movePoint(-2);
    }

    public BasisPoints toBasisPoints() {
        return BasisPoints.fromPercentage(this);
    }

    public Percentage plus(Percentage other) {
        return new Percentage(this.amount.plus(other.amount));
    }

    public Percentage minus(Percentage other) {
        return new Percentage(this.amount.minus(other.amount));
    }

    public Percentage map(UnaryOperator<Decimal> mapper) {
        return new Percentage((Decimal)mapper.apply(this.amount));
    }

    @Override
    public int compareTo(Percentage other) {
        return this.amount.compareTo(other.amount);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Percentage) {
            Percentage other = (Percentage)obj;
            return this.amount.equals(other.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.amount.hashCode();
    }

    @ToString
    public String toString() {
        return this.amount.toString() + '%';
    }
}

