/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.array;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.collect.function.IntLongConsumer;
import com.opengamma.strata.collect.function.IntLongToLongFunction;
import com.opengamma.strata.collect.function.LongTernaryOperator;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.function.IntToLongFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import java.util.stream.LongStream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class LongArray
implements Matrix,
ImmutableBean,
Serializable {
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final LongArray EMPTY = new LongArray(EMPTY_LONG_ARRAY);
    private static final long serialVersionUID = 1L;
    private final long[] array;

    public static LongArray of() {
        return EMPTY;
    }

    public static LongArray of(long value) {
        return new LongArray(new long[]{value});
    }

    public static LongArray of(long value1, long value2) {
        return new LongArray(new long[]{value1, value2});
    }

    public static LongArray of(long value1, long value2, long value3) {
        return new LongArray(new long[]{value1, value2, value3});
    }

    public static LongArray of(long value1, long value2, long value3, long value4) {
        return new LongArray(new long[]{value1, value2, value3, value4});
    }

    public static LongArray of(long value1, long value2, long value3, long value4, long value5) {
        return new LongArray(new long[]{value1, value2, value3, value4, value5});
    }

    public static LongArray of(long value1, long value2, long value3, long value4, long value5, long value6) {
        return new LongArray(new long[]{value1, value2, value3, value4, value5, value6});
    }

    public static LongArray of(long value1, long value2, long value3, long value4, long value5, long value6, long value7) {
        return new LongArray(new long[]{value1, value2, value3, value4, value5, value6, value7});
    }

    public static LongArray of(long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8) {
        return new LongArray(new long[]{value1, value2, value3, value4, value5, value6, value7, value8});
    }

    public static LongArray of(long value1, long value2, long value3, long value4, long value5, long value6, long value7, long value8, long ... otherValues) {
        long[] base = new long[otherValues.length + 8];
        base[0] = value1;
        base[1] = value2;
        base[2] = value3;
        base[3] = value4;
        base[4] = value5;
        base[5] = value6;
        base[6] = value7;
        base[7] = value8;
        System.arraycopy(otherValues, 0, base, 8, otherValues.length);
        return new LongArray(base);
    }

    public static LongArray of(int size, IntToLongFunction valueFunction) {
        if (size == 0) {
            return EMPTY;
        }
        long[] array = new long[size];
        Arrays.setAll(array, valueFunction);
        return new LongArray(array);
    }

    public static LongArray of(LongStream stream) {
        return LongArray.ofUnsafe(stream.toArray());
    }

    public static LongArray ofUnsafe(long[] array) {
        if (array.length == 0) {
            return EMPTY;
        }
        return new LongArray(array);
    }

    public static LongArray copyOf(Collection<Long> collection) {
        if (collection.size() == 0) {
            return EMPTY;
        }
        if (collection instanceof ImmList) {
            return ((ImmList)collection).underlying;
        }
        return new LongArray(Longs.toArray(collection));
    }

    public static LongArray copyOf(long[] array) {
        if (array.length == 0) {
            return EMPTY;
        }
        return new LongArray((long[])array.clone());
    }

    public static LongArray copyOf(long[] array, int fromIndex) {
        return LongArray.copyOf(array, fromIndex, array.length);
    }

    public static LongArray copyOf(long[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + fromIndexInclusive + " > " + array.length);
        }
        if (toIndexExclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + toIndexExclusive + " > " + array.length);
        }
        if (toIndexExclusive - fromIndexInclusive == 0) {
            return EMPTY;
        }
        return new LongArray(Arrays.copyOfRange(array, fromIndexInclusive, toIndexExclusive));
    }

    public static LongArray filled(int size) {
        if (size == 0) {
            return EMPTY;
        }
        return new LongArray(new long[size]);
    }

    public static LongArray filled(int size, long value) {
        if (size == 0) {
            return EMPTY;
        }
        long[] array = new long[size];
        Arrays.fill(array, value);
        return new LongArray(array);
    }

    private LongArray(long[] array) {
        this.array = array;
    }

    @Override
    public int dimensions() {
        return 1;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public long get(int index) {
        return this.array[index];
    }

    public boolean contains(long value) {
        return Longs.contains((long[])this.array, (long)value);
    }

    public int indexOf(long value) {
        return Longs.indexOf((long[])this.array, (long)value);
    }

    public int lastIndexOf(long value) {
        return Longs.lastIndexOf((long[])this.array, (long)value);
    }

    public void copyInto(long[] destination, int offset) {
        if (destination.length < this.array.length + offset) {
            throw new IndexOutOfBoundsException("Destination array is not large enough");
        }
        System.arraycopy(this.array, 0, destination, offset, this.array.length);
    }

    public LongArray subArray(int fromIndexInclusive) {
        return this.subArray(fromIndexInclusive, this.array.length);
    }

    public LongArray subArray(int fromIndexInclusive, int toIndexExclusive) {
        return LongArray.copyOf(this.array, fromIndexInclusive, toIndexExclusive);
    }

    public long[] toArray() {
        return (long[])this.array.clone();
    }

    public long[] toArrayUnsafe() {
        return this.array;
    }

    public List<Long> toList() {
        return new ImmList(this);
    }

    public LongStream stream() {
        return LongStream.of(this.array);
    }

    public void forEach(IntLongConsumer action) {
        for (int i = 0; i < this.array.length; ++i) {
            action.accept(i, this.array[i]);
        }
    }

    public LongArray with(int index, long newValue) {
        if (this.array[index] == newValue) {
            return this;
        }
        long[] result = (long[])this.array.clone();
        result[index] = newValue;
        return new LongArray(result);
    }

    public LongArray plus(long amount) {
        if (amount == 0L) {
            return this;
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] + amount;
        }
        return new LongArray(result);
    }

    public LongArray minus(long amount) {
        if (amount == 0L) {
            return this;
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] - amount;
        }
        return new LongArray(result);
    }

    public LongArray multipliedBy(long factor) {
        if (factor == 1L) {
            return this;
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * factor;
        }
        return new LongArray(result);
    }

    public LongArray dividedBy(long divisor) {
        if (divisor == 1L) {
            return this;
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] / divisor;
        }
        return new LongArray(result);
    }

    public LongArray map(LongUnaryOperator operator) {
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = operator.applyAsLong(this.array[i]);
        }
        return new LongArray(result);
    }

    public LongArray mapWithIndex(IntLongToLongFunction function) {
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = function.applyAsLong(i, this.array[i]);
        }
        return new LongArray(result);
    }

    public LongArray plus(LongArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] + other.array[i];
        }
        return new LongArray(result);
    }

    public LongArray minus(LongArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] - other.array[i];
        }
        return new LongArray(result);
    }

    public LongArray multipliedBy(LongArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] * other.array[i];
        }
        return new LongArray(result);
    }

    public LongArray dividedBy(LongArray other) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = this.array[i] / other.array[i];
        }
        return new LongArray(result);
    }

    public LongArray combine(LongArray other, LongBinaryOperator operator) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        long[] result = new long[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            result[i] = operator.applyAsLong(this.array[i], other.array[i]);
        }
        return new LongArray(result);
    }

    public long combineReduce(LongArray other, LongTernaryOperator operator) {
        if (this.array.length != other.array.length) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        long result = 0L;
        for (int i = 0; i < this.array.length; ++i) {
            result = operator.applyAsLong(result, this.array[i], other.array[i]);
        }
        return result;
    }

    public LongArray concat(long ... arrayToConcat) {
        if (this.array.length == 0) {
            return LongArray.copyOf(arrayToConcat);
        }
        if (arrayToConcat.length == 0) {
            return this;
        }
        long[] result = new long[this.array.length + arrayToConcat.length];
        System.arraycopy(this.array, 0, result, 0, this.array.length);
        System.arraycopy(arrayToConcat, 0, result, this.array.length, arrayToConcat.length);
        return new LongArray(result);
    }

    public LongArray concat(LongArray arrayToConcat) {
        if (this.array.length == 0) {
            return arrayToConcat;
        }
        if (arrayToConcat.array.length == 0) {
            return this;
        }
        return this.concat(arrayToConcat.array);
    }

    public LongArray sorted() {
        if (this.array.length < 2) {
            return this;
        }
        long[] result = (long[])this.array.clone();
        Arrays.sort(result);
        return new LongArray(result);
    }

    public long min() {
        if (this.array.length == 0) {
            throw new IllegalStateException("Unable to find minimum of an empty array");
        }
        if (this.array.length == 1) {
            return this.array[0];
        }
        long min = Long.MAX_VALUE;
        for (int i = 0; i < this.array.length; ++i) {
            min = Math.min(min, this.array[i]);
        }
        return min;
    }

    public long max() {
        if (this.array.length == 0) {
            throw new IllegalStateException("Unable to find maximum of an empty array");
        }
        if (this.array.length == 1) {
            return this.array[0];
        }
        long max = Long.MIN_VALUE;
        for (int i = 0; i < this.array.length; ++i) {
            max = Math.max(max, this.array[i]);
        }
        return max;
    }

    public long sum() {
        long total = 0L;
        for (int i = 0; i < this.array.length; ++i) {
            total += this.array[i];
        }
        return total;
    }

    public long reduce(long identity, LongBinaryOperator operator) {
        long result = identity;
        for (int i = 0; i < this.array.length; ++i) {
            result = operator.applyAsLong(result, this.array[i]);
        }
        return result;
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LongArray) {
            LongArray other = (LongArray)obj;
            return Arrays.equals(this.array, other.array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<long[]> ARRAY = new BasicMetaProperty<long[]>("array"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return LongArray.class;
            }

            public Class<long[]> propertyType() {
                return long[].class;
            }

            public Type propertyGenericType() {
                return long[].class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public long[] get(Bean bean) {
                return ((LongArray)bean).toArray();
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"array", ARRAY);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<LongArray> builder() {
            return new BasicImmutableBeanBuilder<LongArray>((MetaBean)this){
                private long[] array;
                {
                    super(x0);
                    this.array = EMPTY_LONG_ARRAY;
                }

                public Object get(String propertyName) {
                    if (propertyName.equals(ARRAY.name())) {
                        return this.array.clone();
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<LongArray> set(String propertyName, Object value) {
                    if (!propertyName.equals(ARRAY.name())) {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    this.array = (long[])((long[])ArgChecker.notNull(value, "value")).clone();
                    return this;
                }

                public LongArray build() {
                    return new LongArray(this.array);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return LongArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }

    static class ImmList
    extends AbstractList<Long>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LongArray underlying;

        ImmList(LongArray underlying) {
            this.underlying = underlying;
        }

        @Override
        public int size() {
            return this.underlying.size();
        }

        @Override
        public Long get(int index) {
            return this.underlying.get(index);
        }

        @Override
        public boolean contains(Object obj) {
            return obj instanceof Long && this.underlying.contains((Long)obj);
        }

        @Override
        public int indexOf(Object obj) {
            return obj instanceof Long ? this.underlying.indexOf((Long)obj) : -1;
        }

        @Override
        public int lastIndexOf(Object obj) {
            return obj instanceof Long ? this.underlying.lastIndexOf((Long)obj) : -1;
        }

        @Override
        public ListIterator<Long> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Long> listIterator() {
            return new ImmIterator(this.underlying.array);
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Unable to remove range from LongArray");
        }
    }

    static class ImmIterator
    implements ListIterator<Long> {
        private final long[] array;
        private int index;

        public ImmIterator(long[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Long next() {
            if (this.hasNext()) {
                return this.array[this.index++];
            }
            throw new NoSuchElementException("Iteration has reached the last element");
        }

        @Override
        public Long previous() {
            if (this.hasPrevious()) {
                return this.array[--this.index];
            }
            throw new NoSuchElementException("Iteration has reached the first element");
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Unable to remove from LongArray");
        }

        @Override
        public void set(Long value) {
            throw new UnsupportedOperationException("Unable to set value in LongArray");
        }

        @Override
        public void add(Long value) {
            throw new UnsupportedOperationException("Unable to add value to LongArray");
        }
    }
}

