/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.concurrent;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class CloseableExecutor
implements AutoCloseable {
    private final ExecutorService executorService;
    private final Duration duration;

    private CloseableExecutor(ExecutorService executorService, Duration duration) {
        this.executorService = ArgChecker.notNull(executorService, "executorService");
        this.duration = ArgChecker.notNull(duration, "duration");
        ArgChecker.isFalse(duration.isNegative(), "Duration to wait must be positive or zero: {}", duration);
    }

    public static CloseableExecutor of(ExecutorService executor) {
        return new CloseableExecutor(executor, Duration.ZERO);
    }

    public static CloseableExecutor of(ExecutorService executor, Duration duration) {
        return new CloseableExecutor(executor, duration);
    }

    @Override
    public void close() {
        Unchecked.wrap(() -> {
            this.executorService.shutdown();
            if (!this.duration.isZero()) {
                this.executorService.awaitTermination(this.duration.toMillis(), TimeUnit.MILLISECONDS);
            }
        });
    }
}

