/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.BeanCharSource;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public abstract class BeanByteSource
extends ByteSource
implements ImmutableBean {
    protected BeanByteSource() {
    }

    public Optional<String> getFileName() {
        return Optional.empty();
    }

    public String getFileNameOrThrow() {
        return this.getFileName().orElseThrow(() -> new IllegalArgumentException("No file name present on byte source"));
    }

    public boolean isEmpty() {
        try {
            return super.isEmpty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public long size() {
        try {
            return super.size();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public byte[] read() {
        try {
            return super.read();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String readUtf8() {
        return new String(this.read(), StandardCharsets.UTF_8);
    }

    public String readUtf8UsingBom() {
        return UnicodeBom.toString(this.read());
    }

    public BeanCharSource asCharSource(Charset charset) {
        return new AsBeanCharSource(this, charset);
    }

    public BeanCharSource asCharSourceUtf8() {
        return this.asCharSource(StandardCharsets.UTF_8);
    }

    public BeanCharSource asCharSourceUtf8UsingBom() {
        return UnicodeBom.toCharSource(this);
    }

    public ArrayByteSource load() {
        return ArrayByteSource.from(this);
    }

    public HashCode hash(HashFunction hashFunction) {
        try {
            return super.hash(hashFunction);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ArrayByteSource toHash(HashFunction hashFunction) {
        return ArrayByteSource.ofUnsafe(this.hash(hashFunction).asBytes());
    }

    public String toHashString(HashFunction hashFunction) {
        return this.hash(hashFunction).toString();
    }

    public ArrayByteSource toBase64() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = this.openBufferedStream();
             OutputStream out = Base64.getEncoder().wrap(baos);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return ArrayByteSource.ofUnsafe(baos.toByteArray());
    }

    public String toBase64String() {
        return this.toBase64().readUtf8();
    }

    static class AsBeanCharSource
    extends BeanCharSource {
        private final BeanByteSource underlying;
        private final Charset charset;

        AsBeanCharSource(BeanByteSource underlying, Charset charset) {
            this.underlying = ArgChecker.notNull(underlying, "underlying");
            this.charset = ArgChecker.notNull(charset, "charset");
        }

        public MetaBean metaBean() {
            return Meta.META;
        }

        @Override
        public Optional<String> getFileName() {
            return this.underlying.getFileName();
        }

        @Override
        public BeanByteSource asByteSource(Charset charset) {
            if (charset.equals(this.charset)) {
                return this.underlying;
            }
            return super.asByteSource(charset);
        }

        public Reader openStream() throws IOException {
            return new InputStreamReader(this.underlying.openStream(), this.charset);
        }

        @Override
        public String read() {
            return new String(this.underlying.read(), this.charset);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == ((Object)((Object)this)).getClass()) {
                AsBeanCharSource other = (AsBeanCharSource)((Object)obj);
                return JodaBeanUtils.equal((Object)((Object)this.underlying), (Object)((Object)other.underlying)) && JodaBeanUtils.equal((Object)this.charset, (Object)other.charset);
            }
            return false;
        }

        public int hashCode() {
            int hash = ((Object)((Object)this)).getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.underlying));
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.charset);
            return hash;
        }

        public String toString() {
            return ((Object)((Object)this.underlying)).toString() + ".asCharSource(" + this.charset + ")";
        }

        static {
            MetaBean.register((MetaBean)Meta.META);
        }

        static final class Meta
        extends BasicMetaBean {
            private static final MetaBean META = new Meta();
            private static final MetaProperty<BeanByteSource> UNDERLYING = new BasicMetaProperty<BeanByteSource>("underlying"){

                public MetaBean metaBean() {
                    return META;
                }

                public Class<?> declaringType() {
                    return AsBeanCharSource.class;
                }

                public Class<BeanByteSource> propertyType() {
                    return BeanByteSource.class;
                }

                public Type propertyGenericType() {
                    return BeanByteSource.class;
                }

                public PropertyStyle style() {
                    return PropertyStyle.IMMUTABLE;
                }

                public List<Annotation> annotations() {
                    return ImmutableList.of();
                }

                public BeanByteSource get(Bean bean) {
                    return ((AsBeanCharSource)bean).underlying;
                }

                public void set(Bean bean, Object value) {
                    throw new UnsupportedOperationException("Property cannot be written: " + this.name());
                }
            };
            private static final MetaProperty<String> CHARSET = new BasicMetaProperty<String>("charset"){

                public MetaBean metaBean() {
                    return META;
                }

                public Class<?> declaringType() {
                    return AsBeanCharSource.class;
                }

                public Class<String> propertyType() {
                    return String.class;
                }

                public Type propertyGenericType() {
                    return String.class;
                }

                public PropertyStyle style() {
                    return PropertyStyle.IMMUTABLE;
                }

                public List<Annotation> annotations() {
                    return ImmutableList.of();
                }

                public String get(Bean bean) {
                    return ((AsBeanCharSource)bean).charset.name();
                }

                public void set(Bean bean, Object value) {
                    throw new UnsupportedOperationException("Property cannot be written: " + this.name());
                }
            };
            private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"underlying", UNDERLYING, (Object)"charset", CHARSET);

            private Meta() {
            }

            public boolean isBuildable() {
                return true;
            }

            public BeanBuilder<AsBeanCharSource> builder() {
                return new BasicImmutableBeanBuilder<AsBeanCharSource>((MetaBean)this){
                    private BeanByteSource underlying;
                    private Charset charset;

                    public Object get(String propertyName) {
                        if (propertyName.equals(UNDERLYING.name())) {
                            return this.underlying;
                        }
                        if (propertyName.equals(CHARSET.name())) {
                            return this.charset.name();
                        }
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }

                    public BeanBuilder<AsBeanCharSource> set(String propertyName, Object value) {
                        if (propertyName.equals(UNDERLYING.name())) {
                            this.underlying = (BeanByteSource)((Object)ArgChecker.notNull(value, "underlying"));
                        } else if (propertyName.equals(CHARSET.name())) {
                            this.charset = Charset.forName((String)ArgChecker.notNull(value, "charset"));
                        } else {
                            throw new NoSuchElementException("Unknown property: " + propertyName);
                        }
                        return this;
                    }

                    public AsBeanCharSource build() {
                        ArgChecker.notNull(this.underlying, "underlying");
                        ArgChecker.notNull(this.charset, "charset");
                        return new AsBeanCharSource(this.underlying, this.charset);
                    }
                };
            }

            public Class<? extends Bean> beanType() {
                return AsBeanCharSource.class;
            }

            public Map<String, MetaProperty<?>> metaPropertyMap() {
                return MAP;
            }
        }
    }
}

