/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.timeseries;

import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.function.ObjDoublePredicate;
import com.opengamma.strata.collect.timeseries.LocalDateDoublePoint;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeriesBuilder;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", metaScope="package")
final class SparseLocalDateDoubleTimeSeries
implements ImmutableBean,
Serializable,
LocalDateDoubleTimeSeries {
    static final LocalDateDoubleTimeSeries EMPTY = new SparseLocalDateDoubleTimeSeries(new LocalDate[0], new double[0]);
    @PropertyDefinition(get="manual", validate="notNull")
    private final LocalDate[] dates;
    @PropertyDefinition(get="manual", validate="notNull")
    private final double[] values;
    private static final long serialVersionUID = 1L;

    static SparseLocalDateDoubleTimeSeries of(Collection<LocalDate> dates, Collection<Double> values) {
        ArgChecker.noNulls(dates, "dates");
        ArgChecker.noNulls(values, "values");
        LocalDate[] datesArray = dates.toArray(new LocalDate[dates.size()]);
        double[] valuesArray = Doubles.toArray(values);
        SparseLocalDateDoubleTimeSeries.validate(datesArray, valuesArray);
        return SparseLocalDateDoubleTimeSeries.createUnsafe(datesArray, valuesArray);
    }

    private static SparseLocalDateDoubleTimeSeries createUnsafe(LocalDate[] dates, double[] values) {
        return new SparseLocalDateDoubleTimeSeries(dates, values, true);
    }

    private static void validate(LocalDate[] dates, double[] values) {
        ArgChecker.isTrue(dates.length == values.length, "Arrays are of different sizes - dates: {}, values: {}", dates.length, values.length);
        LocalDate maxDate = LocalDate.MIN;
        for (LocalDate date : dates) {
            ArgChecker.isTrue(date.isAfter(maxDate), "Dates must be in ascending order but: {} is not after: {}", date, maxDate);
            maxDate = date;
        }
    }

    @ImmutableConstructor
    private SparseLocalDateDoubleTimeSeries(LocalDate[] dates, double[] values) {
        ArgChecker.noNulls(dates, "dates");
        ArgChecker.notNull(values, "values");
        SparseLocalDateDoubleTimeSeries.validate(dates, values);
        this.dates = (LocalDate[])dates.clone();
        this.values = (double[])values.clone();
    }

    private SparseLocalDateDoubleTimeSeries(LocalDate[] dates, double[] values, boolean trusted) {
        this.dates = dates;
        this.values = values;
    }

    private LocalDate[] getDates() {
        return (LocalDate[])this.dates.clone();
    }

    private double[] getValues() {
        return (double[])this.values.clone();
    }

    @Override
    public int size() {
        return this.dates.length;
    }

    @Override
    public boolean isEmpty() {
        return this.dates.length == 0;
    }

    @Override
    public boolean containsDate(LocalDate date) {
        return this.findDatePosition(date) >= 0;
    }

    @Override
    public OptionalDouble get(LocalDate date) {
        int position = this.findDatePosition(date);
        return position >= 0 ? OptionalDouble.of(this.values[position]) : OptionalDouble.empty();
    }

    private int findDatePosition(LocalDate date) {
        return Arrays.binarySearch(this.dates, date);
    }

    @Override
    public LocalDate getLatestDate() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Unable to return latest, time-series is empty");
        }
        return this.dates[this.dates.length - 1];
    }

    @Override
    public double getLatestValue() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Unable to return latest, time-series is empty");
        }
        return this.values[this.values.length - 1];
    }

    @Override
    public LocalDateDoubleTimeSeries subSeries(LocalDate startInclusive, LocalDate endExclusive) {
        ArgChecker.notNull(startInclusive, "startInclusive");
        ArgChecker.notNull(endExclusive, "endExclusive");
        if (endExclusive.isBefore(startInclusive)) {
            throw new IllegalArgumentException("Invalid sub series, end before start: " + startInclusive + " to " + endExclusive);
        }
        if (this.isEmpty() || startInclusive.equals(endExclusive)) {
            return EMPTY;
        }
        int startPos = Arrays.binarySearch(this.dates, startInclusive);
        startPos = startPos >= 0 ? startPos : -startPos - 1;
        int endPos = Arrays.binarySearch(this.dates, endExclusive);
        endPos = endPos >= 0 ? endPos : -endPos - 1;
        LocalDate[] timesArray = Arrays.copyOfRange(this.dates, startPos, endPos);
        double[] valuesArray = Arrays.copyOfRange(this.values, startPos, endPos);
        return SparseLocalDateDoubleTimeSeries.createUnsafe(timesArray, valuesArray);
    }

    @Override
    public LocalDateDoubleTimeSeries headSeries(int numPoints) {
        ArgChecker.notNegative(numPoints, "numPoints");
        if (numPoints == 0) {
            return EMPTY;
        }
        if (numPoints >= this.size()) {
            return this;
        }
        LocalDate[] datesArray = Arrays.copyOfRange(this.dates, 0, numPoints);
        double[] valuesArray = Arrays.copyOfRange(this.values, 0, numPoints);
        return SparseLocalDateDoubleTimeSeries.createUnsafe(datesArray, valuesArray);
    }

    @Override
    public LocalDateDoubleTimeSeries tailSeries(int numPoints) {
        ArgChecker.notNegative(numPoints, "numPoints");
        if (numPoints == 0) {
            return EMPTY;
        }
        if (numPoints >= this.size()) {
            return this;
        }
        LocalDate[] datesArray = Arrays.copyOfRange(this.dates, this.size() - numPoints, this.size());
        double[] valuesArray = Arrays.copyOfRange(this.values, this.size() - numPoints, this.size());
        return SparseLocalDateDoubleTimeSeries.createUnsafe(datesArray, valuesArray);
    }

    @Override
    public Stream<LocalDateDoublePoint> stream() {
        return IntStream.range(0, this.size()).mapToObj(i -> LocalDateDoublePoint.of(this.dates[i], this.values[i]));
    }

    @Override
    public Stream<LocalDate> dates() {
        return Stream.of(this.dates);
    }

    @Override
    public DoubleStream values() {
        return DoubleStream.of(this.values);
    }

    @Override
    public void forEach(ObjDoubleConsumer<LocalDate> action) {
        ArgChecker.notNull(action, "action");
        for (int i = 0; i < this.size(); ++i) {
            action.accept(this.dates[i], this.values[i]);
        }
    }

    @Override
    public LocalDateDoubleTimeSeries mapDates(Function<? super LocalDate, ? extends LocalDate> mapper) {
        ArgChecker.notNull(mapper, "mapper");
        LocalDate[] dates = (LocalDate[])Arrays.stream(this.dates).map(mapper).toArray(LocalDate[]::new);
        Arrays.stream(dates).reduce(this::checkAscending);
        return SparseLocalDateDoubleTimeSeries.createUnsafe(dates, this.values);
    }

    @Override
    public LocalDateDoubleTimeSeries mapValues(DoubleUnaryOperator mapper) {
        ArgChecker.notNull(mapper, "mapper");
        return SparseLocalDateDoubleTimeSeries.createUnsafe(this.dates, DoubleStream.of(this.values).map(mapper).toArray());
    }

    @Override
    public LocalDateDoubleTimeSeries filter(ObjDoublePredicate<LocalDate> predicate) {
        ArgChecker.notNull(predicate, "predicate");
        LocalDate[] resDates = new LocalDate[this.size()];
        double[] resValues = new double[this.size()];
        int resCount = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!predicate.test(this.dates[i], this.values[i])) continue;
            resDates[resCount] = this.dates[i];
            resValues[resCount] = this.values[i];
            ++resCount;
        }
        return SparseLocalDateDoubleTimeSeries.createUnsafe(Arrays.copyOf(resDates, resCount), Arrays.copyOf(resValues, resCount));
    }

    @Override
    public LocalDateDoubleTimeSeriesBuilder toBuilder() {
        return new LocalDateDoubleTimeSeriesBuilder(this.dates, this.values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SparseLocalDateDoubleTimeSeries) {
            SparseLocalDateDoubleTimeSeries other = (SparseLocalDateDoubleTimeSeries)obj;
            return Arrays.equals(this.dates, other.dates) && Arrays.equals(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.dates) + Arrays.hashCode(this.values);
    }

    public String toString() {
        return this.stream().map(LocalDateDoublePoint::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    private LocalDate checkAscending(LocalDate earlier, LocalDate later) {
        if (earlier.isBefore(later)) {
            return later;
        }
        throw new IllegalArgumentException(Messages.format("Dates must be in ascending order after calling mapDates but {} and {} are not", earlier, later));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SparseLocalDateDoubleTimeSeries> {
        private LocalDate[] dates;
        private double[] values;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    return this.dates;
                }
                case -823812830: {
                    return this.values;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    this.dates = (LocalDate[])newValue;
                    break;
                }
                case -823812830: {
                    this.values = (double[])newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SparseLocalDateDoubleTimeSeries build() {
            return new SparseLocalDateDoubleTimeSeries(this.dates, this.values);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("SparseLocalDateDoubleTimeSeries.Builder{");
            buf.append("dates").append('=').append(JodaBeanUtils.toString((Object)this.dates)).append(',').append(' ');
            buf.append("values").append('=').append(JodaBeanUtils.toString((Object)this.values));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate[]> dates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dates", SparseLocalDateDoubleTimeSeries.class, LocalDate[].class);
        private final MetaProperty<double[]> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", SparseLocalDateDoubleTimeSeries.class, double[].class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"dates", "values"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    return this.dates;
                }
                case -823812830: {
                    return this.values;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SparseLocalDateDoubleTimeSeries> builder() {
            return new Builder();
        }

        public Class<? extends SparseLocalDateDoubleTimeSeries> beanType() {
            return SparseLocalDateDoubleTimeSeries.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate[]> dates() {
            return this.dates;
        }

        public MetaProperty<double[]> values() {
            return this.values;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    return ((SparseLocalDateDoubleTimeSeries)bean).getDates();
                }
                case -823812830: {
                    return ((SparseLocalDateDoubleTimeSeries)bean).getValues();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

