/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.function.CheckedSupplier;
import com.opengamma.strata.collect.io.BeanByteSource;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class ArrayByteSource
extends BeanByteSource
implements ImmutableBean,
Serializable {
    public static final ArrayByteSource EMPTY = new ArrayByteSource(new byte[0]);
    private static final long serialVersionUID = 1L;
    private final byte[] array;

    public static ArrayByteSource copyOf(byte[] array) {
        return new ArrayByteSource((byte[])array.clone());
    }

    public static ArrayByteSource copyOf(byte[] array, int fromIndex) {
        return ArrayByteSource.copyOf(array, fromIndex, array.length);
    }

    public static ArrayByteSource copyOf(byte[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + fromIndexInclusive + " > " + array.length);
        }
        if (toIndexExclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + toIndexExclusive + " > " + array.length);
        }
        if (toIndexExclusive - fromIndexInclusive == 0) {
            return EMPTY;
        }
        return new ArrayByteSource(Arrays.copyOfRange(array, fromIndexInclusive, toIndexExclusive));
    }

    public static ArrayByteSource ofUnsafe(byte[] array) {
        return new ArrayByteSource(array);
    }

    public static ArrayByteSource ofUtf8(String str) {
        return new ArrayByteSource(str.getBytes(StandardCharsets.UTF_8));
    }

    public static ArrayByteSource from(ByteSource other) {
        if (other instanceof ArrayByteSource) {
            return (ArrayByteSource)other;
        }
        return new ArrayByteSource(Unchecked.wrap(() -> other.read()));
    }

    public static ArrayByteSource from(CheckedSupplier<InputStream> inputStreamSupplier) {
        return Unchecked.wrap(() -> {
            try (InputStream in = (InputStream)inputStreamSupplier.get();){
                byte[] bytes = Unchecked.wrap(() -> ByteStreams.toByteArray((InputStream)in));
                ArrayByteSource arrayByteSource = new ArrayByteSource(bytes);
                return arrayByteSource;
            }
        });
    }

    public static ArrayByteSource fromBase64(String base64) {
        return new ArrayByteSource(Base64.getDecoder().decode(base64));
    }

    public static ArrayByteSource fromHex(String hex) {
        return new ArrayByteSource(BaseEncoding.base16().decode((CharSequence)hex));
    }

    private ArrayByteSource(byte[] array) {
        this.array = array;
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    public byte[] readUnsafe() {
        return this.array;
    }

    @Override
    public String readUtf8() {
        return new String(this.array, StandardCharsets.UTF_8);
    }

    @Override
    public String readUtf8UsingBom() {
        return UnicodeBom.toString(this.array);
    }

    @Override
    public CharSource asCharSourceUtf8UsingBom() {
        return CharSource.wrap((CharSequence)this.readUtf8UsingBom());
    }

    public ArrayByteSource toMd5() {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return ArrayByteSource.ofUnsafe(md.digest(this.array));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public ArrayByteSource toSha512() {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            return ArrayByteSource.ofUnsafe(md.digest(this.array));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public ArrayByteSource toBase64() {
        return ArrayByteSource.ofUnsafe(Base64.getEncoder().encode(this.array));
    }

    public String toBase64String() {
        return Base64.getEncoder().encodeToString(this.array);
    }

    public String toHexString() {
        return BaseEncoding.base16().encode(this.array);
    }

    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.array);
    }

    public ByteArrayInputStream openBufferedStream() {
        return this.openStream();
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public Optional<Long> sizeIfKnown() {
        return Optional.of((Object)this.size());
    }

    @Override
    public long size() {
        return this.array.length;
    }

    public ArrayByteSource slice(long offset, long length) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset (%s) may not be negative", (long)offset);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (String)"length (%s) may not be negative", (long)length);
        if (offset > (long)this.array.length) {
            return EMPTY;
        }
        int minPos = (int)offset;
        long len = Math.min(Math.min(length, Integer.MAX_VALUE), (long)this.array.length);
        int maxPos = (int)Math.min((long)minPos + len, (long)this.array.length);
        return new ArrayByteSource(Arrays.copyOfRange(this.array, minPos, maxPos));
    }

    public long copyTo(OutputStream output) throws IOException {
        output.write(this.array);
        return this.array.length;
    }

    @Override
    public byte[] read() {
        return (byte[])this.array.clone();
    }

    public <T> T read(ByteProcessor<T> processor) throws IOException {
        processor.processBytes(this.array, 0, this.array.length);
        return (T)processor.getResult();
    }

    public HashCode hash(HashFunction hashFunction) {
        return hashFunction.hashBytes(this.array);
    }

    public boolean contentEquals(ByteSource other) throws IOException {
        if (other instanceof ArrayByteSource) {
            return this.equals(other);
        }
        return super.contentEquals(other);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayByteSource) {
            return Arrays.equals(this.array, ((ArrayByteSource)obj).array);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public String toString() {
        return "ArrayByteSource[" + this.size() + " bytes]";
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<byte[]> ARRAY = new BasicMetaProperty<byte[]>("array"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return ArrayByteSource.class;
            }

            public Class<byte[]> propertyType() {
                return byte[].class;
            }

            public Type propertyGenericType() {
                return byte[].class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public byte[] get(Bean bean) {
                return ((ArrayByteSource)bean).read();
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"array", ARRAY);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<ArrayByteSource> builder() {
            return new BasicImmutableBeanBuilder<ArrayByteSource>((MetaBean)this){
                private byte[] array;
                {
                    super(x0);
                    this.array = new byte[0];
                }

                public Object get(String propertyName) {
                    if (propertyName.equals(ARRAY.name())) {
                        return this.array;
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<ArrayByteSource> set(String propertyName, Object value) {
                    if (!propertyName.equals(ARRAY.name())) {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    this.array = (byte[])ArgChecker.notNull(value, "value");
                    return this;
                }

                public ArrayByteSource build() {
                    return ArrayByteSource.ofUnsafe(this.array);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return ArrayByteSource.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }
}

