/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import org.joda.beans.ImmutableBean;

public abstract class BeanByteSource
extends ByteSource
implements ImmutableBean {
    protected BeanByteSource() {
    }

    public boolean isEmpty() {
        try {
            return super.isEmpty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public long size() {
        try {
            return super.size();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public byte[] read() {
        try {
            return super.read();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String readUtf8() {
        return new String(this.read(), StandardCharsets.UTF_8);
    }

    public String readUtf8UsingBom() {
        return UnicodeBom.toString(this.read());
    }

    public CharSource asCharSourceUtf8() {
        return this.asCharSource(StandardCharsets.UTF_8);
    }

    public CharSource asCharSourceUtf8UsingBom() {
        return UnicodeBom.toCharSource(this);
    }

    public ArrayByteSource load() {
        return ArrayByteSource.from(this);
    }
}

