/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.io.CsvFile;
import com.opengamma.strata.collect.io.CsvIterator;
import com.opengamma.strata.collect.io.CsvRow;
import com.opengamma.strata.collect.tuple.ObjIntPair;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.joda.beans.JodaBeanUtils;

public final class CsvOutput {
    private static final String DIGITS = "(?:[0-9]++(?:[.][0-9]*+)?+|[.][0-9]++)";
    private static final String EXPONENT = "(?:[eE][+-]?+[0-9]++)?+";
    private static final Pattern FP_REGEX = Pattern.compile("(?:[0-9]++(?:[.][0-9]*+)?+|[.][0-9]++)(?:[eE][+-]?+[0-9]++)?+");
    private static final String COMMA = ",";
    private static final String NEW_LINE = System.lineSeparator();
    private final Appendable underlying;
    private final String newLine;
    private final String separator;
    private final boolean safeExpressions;
    private boolean lineStarted;

    public static CsvOutput standard(Appendable underlying) {
        return new CsvOutput(underlying, NEW_LINE, COMMA, false);
    }

    public static CsvOutput standard(Appendable underlying, String newLine) {
        return new CsvOutput(underlying, newLine, COMMA, false);
    }

    public static CsvOutput standard(Appendable underlying, String newLine, String separator) {
        return new CsvOutput(underlying, newLine, separator, false);
    }

    public static CsvOutput safe(Appendable underlying) {
        return new CsvOutput(underlying, NEW_LINE, COMMA, true);
    }

    public static CsvOutput safe(Appendable underlying, String newLine) {
        return new CsvOutput(underlying, newLine, COMMA, true);
    }

    public static CsvOutput safe(Appendable underlying, String newLine, String separator) {
        return new CsvOutput(underlying, newLine, separator, true);
    }

    private CsvOutput(Appendable underlying, String newLine, String separator, boolean safeExpressions) {
        this.underlying = ArgChecker.notNull(underlying, "underlying");
        this.newLine = newLine;
        this.separator = separator;
        this.safeExpressions = safeExpressions;
    }

    public CsvRowOutputWithHeaders withHeaders(List<String> headers, boolean alwaysQuote) {
        ImmutableMap<String, Integer> headerIndices = Guavate.zipWithIndex(headers.stream()).collect(Guavate.toImmutableMap(ObjIntPair::getFirst, ObjIntPair::getSecond));
        this.writeLine(headers, alwaysQuote);
        return new CsvRowOutputWithHeaders(ImmutableList.copyOf(headers), headerIndices, alwaysQuote);
    }

    public void writeLines(Iterable<? extends List<String>> lines, boolean alwaysQuote) {
        ArgChecker.notNull(lines, "lines");
        for (List<String> list : lines) {
            this.writeLine(list, alwaysQuote);
        }
    }

    public void writeLine(List<String> line) {
        this.writeLine(line, false);
    }

    public void writeLine(List<String> line, boolean alwaysQuote) {
        ArgChecker.notNull(line, "line");
        for (String cell : line) {
            this.writeCell(cell, alwaysQuote);
        }
        this.writeNewLine();
    }

    public void writeRows(Iterable<CsvRow> rows, boolean alwaysQuote) {
        ArgChecker.notNull(rows, "rows");
        for (CsvRow row : rows) {
            this.writeRow(row, alwaysQuote);
        }
    }

    public void writeRow(CsvRow row) {
        this.writeRow(row, false);
    }

    public void writeRow(CsvRow row, boolean alwaysQuote) {
        ArgChecker.notNull(row, "row");
        for (String cell : row.fields()) {
            this.writeCell(cell, alwaysQuote);
        }
        this.writeNewLine();
    }

    public void writeCsvFile(CsvFile file, boolean alwaysQuote) {
        this.writeLine((List<String>)file.headers(), alwaysQuote);
        this.writeRows((Iterable<CsvRow>)file.rows(), alwaysQuote);
    }

    public void writeCsvIterator(CsvIterator iterator, boolean alwaysQuote) {
        this.writeLine((List<String>)iterator.headers(), alwaysQuote);
        iterator.asStream().forEachOrdered(row -> this.writeRow((CsvRow)row, alwaysQuote));
    }

    public CsvOutput writeCell(String cell) {
        this.writeCell(cell, false);
        return this;
    }

    public CsvOutput writeCell(String cell, boolean alwaysQuote) {
        try {
            if (this.lineStarted) {
                this.underlying.append(this.separator);
            }
            if (alwaysQuote || this.isQuotingRequired(cell)) {
                this.outputQuotedCell(cell);
            } else {
                this.underlying.append(cell);
            }
            this.lineStarted = true;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this;
    }

    public CsvOutput writeNewLine() {
        try {
            this.underlying.append(this.newLine);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.lineStarted = false;
        return this;
    }

    private boolean isQuotingRequired(String cell) {
        return cell.indexOf(34) >= 0 || cell.indexOf(44) >= 0 || cell.trim().length() != cell.length() || this.isExpressionPrefix(cell);
    }

    private boolean isExpressionPrefix(String cell) {
        if (cell.isEmpty()) {
            return false;
        }
        char first = cell.charAt(0);
        if (first == '=' || first == '@') {
            return true;
        }
        if (this.safeExpressions && (first == '+' || first == '-')) {
            return !FP_REGEX.matcher(cell.substring(1)).matches();
        }
        return false;
    }

    private void outputQuotedCell(String cell) throws IOException {
        if (this.safeExpressions && this.isExpressionPrefix(cell)) {
            this.underlying.append('=');
        }
        this.underlying.append('\"');
        this.underlying.append(cell.replace("\"", "\"\""));
        this.underlying.append('\"');
    }

    public class CsvRowOutputWithHeaders {
        private final ImmutableList<String> headers;
        private final ImmutableMap<String, Integer> headerIndices;
        private final boolean alwaysQuote;
        private final List<String> mutableValueList;

        private CsvRowOutputWithHeaders(ImmutableList<String> headers, ImmutableMap<String, Integer> headerIndices, boolean alwaysQuote) {
            this.headers = headers;
            this.headerIndices = headerIndices;
            this.alwaysQuote = alwaysQuote;
            this.mutableValueList = new ArrayList<String>(Collections.nCopies(headerIndices.size(), ""));
        }

        public ImmutableList<String> headers() {
            return this.headers;
        }

        public CsvRowOutputWithHeaders writeLine(Map<String, String> valueMap) {
            return this.writeCells(valueMap).writeNewLine();
        }

        public CsvRowOutputWithHeaders writeCells(Map<String, String> valueMap) {
            valueMap.forEach(this::writeCell);
            return this;
        }

        public CsvRowOutputWithHeaders writeCell(String header, String value) {
            Integer index = (Integer)this.headerIndices.get((Object)header);
            if (index == null) {
                throw new IllegalArgumentException("Unknown header: " + header);
            }
            this.mutableValueList.set(index, value);
            return this;
        }

        public CsvRowOutputWithHeaders writeCell(String header, Object value) {
            if (value instanceof Double) {
                return this.writeCell(header, (Double)value);
            }
            if (value instanceof Float) {
                return this.writeCell(header, ((Float)value).doubleValue());
            }
            return this.writeCell(header, JodaBeanUtils.stringConverter().convertToString(value));
        }

        public CsvRowOutputWithHeaders writeCell(String header, double value) {
            String str = BigDecimal.valueOf(value).toPlainString();
            return this.writeCell(header, str.endsWith(".0") ? str.substring(0, str.length() - 2) : str);
        }

        public CsvRowOutputWithHeaders writeCell(String header, long value) {
            return this.writeCell(header, (Object)value);
        }

        public CsvRowOutputWithHeaders writeNewLine() {
            CsvOutput.this.writeLine(this.mutableValueList, this.alwaysQuote);
            this.mutableValueList.replaceAll(current -> "");
            return this;
        }
    }
}

