/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.BeanByteSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class FileByteSource
extends BeanByteSource
implements ImmutableBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private final File file;

    public static FileByteSource of(File file) {
        return new FileByteSource(file);
    }

    public static FileByteSource of(Path path) {
        return new FileByteSource(path.toFile());
    }

    private FileByteSource(File file) {
        this.file = ArgChecker.notNull(file, "file");
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream openStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public Optional<Long> sizeIfKnown() {
        if (this.file.isFile()) {
            return Optional.of((Object)this.file.length());
        }
        return Optional.absent();
    }

    @Override
    public long size() {
        if (!this.file.isFile()) {
            throw new UncheckedIOException(new FileNotFoundException(this.file.toString()));
        }
        return this.file.length();
    }

    public boolean equals(Object other) {
        if (other instanceof FileByteSource) {
            return this.file.equals(((FileByteSource)other).file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return "FileByteSource[" + this.file + "]";
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<File> PROP_FILE = new BasicMetaProperty<File>("file"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return FileByteSource.class;
            }

            public Class<File> propertyType() {
                return File.class;
            }

            public Type propertyGenericType() {
                return File.class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public File get(Bean bean) {
                return ((FileByteSource)bean).file;
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"file", PROP_FILE);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<FileByteSource> builder() {
            return new BasicImmutableBeanBuilder<FileByteSource>((MetaBean)this){
                private File file;

                public Object get(String propertyName) {
                    if (propertyName.equals(PROP_FILE.name())) {
                        return this.file;
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<FileByteSource> set(String propertyName, Object value) {
                    if (!propertyName.equals(PROP_FILE.name())) {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    this.file = (File)ArgChecker.notNull(value, "value");
                    return this;
                }

                public FileByteSource build() {
                    return new FileByteSource(this.file);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return FileByteSource.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }
}

