/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.google.common.primitives.Bytes;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.function.CheckedSupplier;
import com.opengamma.strata.collect.io.BeanByteSource;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class ArrayByteSource
extends BeanByteSource
implements ImmutableBean,
Serializable {
    public static final ArrayByteSource EMPTY = new ArrayByteSource(new byte[0]);
    private static final long serialVersionUID = 1L;
    private final byte[] array;
    private final String fileName;

    public static ArrayByteSource copyOf(byte[] array) {
        return new ArrayByteSource((byte[])array.clone());
    }

    public static ArrayByteSource copyOf(byte[] array, int fromIndex) {
        return ArrayByteSource.copyOf(array, fromIndex, array.length);
    }

    public static ArrayByteSource copyOf(byte[] array, int fromIndexInclusive, int toIndexExclusive) {
        if (fromIndexInclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + fromIndexInclusive + " > " + array.length);
        }
        if (toIndexExclusive > array.length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + toIndexExclusive + " > " + array.length);
        }
        if (toIndexExclusive - fromIndexInclusive == 0) {
            return EMPTY;
        }
        return new ArrayByteSource(Arrays.copyOfRange(array, fromIndexInclusive, toIndexExclusive));
    }

    public static ArrayByteSource ofUnsafe(byte[] array) {
        return new ArrayByteSource(array);
    }

    public static ArrayByteSource ofUtf8(String str) {
        return new ArrayByteSource(str.getBytes(StandardCharsets.UTF_8));
    }

    public static ArrayByteSource from(ByteSource other) {
        if (other instanceof ArrayByteSource) {
            return (ArrayByteSource)other;
        }
        String fileName = null;
        if (other instanceof BeanByteSource) {
            fileName = ((BeanByteSource)other).getFileName().orElse(null);
        } else {
            if (other.getClass().getName().equals("com.google.common.io.ByteSource$ByteArrayByteSource")) {
                ByteProcessor<byte[]> processor = new ByteProcessor<byte[]>(){
                    private byte[] captured;

                    public boolean processBytes(byte[] buf, int off, int len) throws IOException {
                        this.captured = this.captured != null ? Bytes.concat((byte[][])new byte[][]{this.captured, Arrays.copyOfRange(buf, off, off + len)}) : (off == 0 && len == buf.length ? buf : Arrays.copyOfRange(buf, off, off + len));
                        return true;
                    }

                    public byte[] getResult() {
                        return this.captured;
                    }
                };
                return Unchecked.wrap(() -> ArrayByteSource.lambda$from$0(other, (ByteProcessor)processor));
            }
            String str = other.toString();
            if (str.equals("ByteSource.empty()")) {
                return EMPTY;
            }
            if (str.startsWith("Files.asByteSource(")) {
                int pos = str.indexOf(41, 19);
                fileName = Paths.get(str.substring(19, pos), new String[0]).getFileName().toString();
            } else if (str.startsWith("MoreFiles.asByteSource(")) {
                int pos = str.indexOf(44, 23);
                fileName = Paths.get(str.substring(23, pos), new String[0]).getFileName().toString();
            } else if (str.startsWith("Resources.asByteSource(")) {
                int pos = str.indexOf(41, 23);
                String path = str.substring(23, pos);
                int lastSlash = path.lastIndexOf(47);
                fileName = path.substring(lastSlash + 1);
            }
        }
        return new ArrayByteSource(Unchecked.wrap(() -> other.read()), fileName);
    }

    public static ArrayByteSource from(CheckedSupplier<InputStream> inputStreamSupplier) {
        return Unchecked.wrap(() -> {
            try (InputStream in = (InputStream)inputStreamSupplier.get();){
                ArrayByteSource arrayByteSource = ArrayByteSource.from(in);
                return arrayByteSource;
            }
        });
    }

    public static ArrayByteSource from(InputStream inputStream) throws IOException {
        byte[] bytes = ByteStreams.toByteArray((InputStream)inputStream);
        return new ArrayByteSource(bytes);
    }

    public static ArrayByteSource from(InputStream inputStream, int expectedSize) throws IOException {
        int read;
        ArgChecker.notNegative(expectedSize, "expectedSize");
        byte[] main = new byte[expectedSize];
        for (int remaining = expectedSize; remaining > 0; remaining -= read) {
            int offset = expectedSize - remaining;
            read = inputStream.read(main, offset, remaining);
            if (read != -1) continue;
            return new ArrayByteSource(Arrays.copyOf(main, offset));
        }
        int firstExcess = inputStream.read();
        if (firstExcess == -1) {
            return new ArrayByteSource(main);
        }
        byte[] excess = ByteStreams.toByteArray((InputStream)inputStream);
        byte[] result = Arrays.copyOf(main, main.length + 1 + excess.length);
        result[main.length] = (byte)firstExcess;
        System.arraycopy(excess, 0, result, main.length + 1, excess.length);
        return new ArrayByteSource(result);
    }

    public static ArrayByteSource fromBase64(String base64) {
        return new ArrayByteSource(Base64.getDecoder().decode(base64));
    }

    public static ArrayByteSource fromHex(String hex) {
        return new ArrayByteSource(BaseEncoding.base16().decode((CharSequence)hex));
    }

    private ArrayByteSource(byte[] array) {
        this.array = array;
        this.fileName = null;
    }

    ArrayByteSource(byte[] array, String fileName) {
        this.array = array;
        this.fileName = Strings.emptyToNull((String)fileName);
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    @Override
    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public ArrayByteSource withFileName(String fileName) {
        ArgChecker.notNull(fileName, "fileName");
        int lastSlash = fileName.lastIndexOf(47);
        return new ArrayByteSource(this.array, fileName.substring(lastSlash + 1));
    }

    public byte[] readUnsafe() {
        return this.array;
    }

    @Override
    public String readUtf8() {
        return new String(this.array, StandardCharsets.UTF_8);
    }

    @Override
    public String readUtf8UsingBom() {
        return UnicodeBom.toString(this.array);
    }

    @Override
    public CharSource asCharSourceUtf8UsingBom() {
        return UnicodeBom.toCharSource(this);
    }

    @Override
    public HashCode hash(HashFunction hashFunction) {
        return hashFunction.hashBytes(this.array);
    }

    @Deprecated
    public ArrayByteSource toMd5() {
        return this.toHash(Hashing.md5());
    }

    @Deprecated
    public ArrayByteSource toSha512() {
        return ArrayByteSource.ofUnsafe(this.hash(Hashing.sha512()).asBytes());
    }

    @Override
    public ArrayByteSource toBase64() {
        return ArrayByteSource.ofUnsafe(Base64.getEncoder().encode(this.array));
    }

    @Override
    public String toBase64String() {
        return Base64.getEncoder().encodeToString(this.array);
    }

    public String toHexString() {
        return BaseEncoding.base16().encode(this.array);
    }

    public ByteArrayInputStream openStream() {
        return new ByteArrayInputStream(this.array);
    }

    public ByteArrayInputStream openBufferedStream() {
        return this.openStream();
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public com.google.common.base.Optional<Long> sizeIfKnown() {
        return com.google.common.base.Optional.of((Object)this.size());
    }

    @Override
    public long size() {
        return this.array.length;
    }

    public ArrayByteSource slice(long offset, long length) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (String)"offset (%s) may not be negative", (long)offset);
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0, (String)"length (%s) may not be negative", (long)length);
        if (offset > (long)this.array.length) {
            return EMPTY;
        }
        int minPos = (int)offset;
        long len = Math.min(Math.min(length, Integer.MAX_VALUE), (long)this.array.length);
        int maxPos = (int)Math.min((long)minPos + len, (long)this.array.length);
        return new ArrayByteSource(Arrays.copyOfRange(this.array, minPos, maxPos), this.fileName);
    }

    public long copyTo(OutputStream output) throws IOException {
        output.write(this.array);
        return this.array.length;
    }

    @Override
    public byte[] read() {
        return (byte[])this.array.clone();
    }

    public <T> T read(ByteProcessor<T> processor) throws IOException {
        processor.processBytes(this.array, 0, this.array.length);
        return (T)processor.getResult();
    }

    public boolean contentEquals(ByteSource other) throws IOException {
        if (other instanceof ArrayByteSource) {
            return this.equals(other);
        }
        return super.contentEquals(other);
    }

    @Override
    public ArrayByteSource load() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ArrayByteSource other = (ArrayByteSource)obj;
            return JodaBeanUtils.equal((Object)this.fileName, (Object)other.fileName) && JodaBeanUtils.equal((Object)this.array, (Object)other.array);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fileName);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.array);
        return hash;
    }

    public String toString() {
        return "ArrayByteSource[" + this.size() + " bytes" + (this.fileName != null ? ", " + this.fileName : "") + "]";
    }

    private static /* synthetic */ ArrayByteSource lambda$from$0(ByteSource other, ByteProcessor processor) throws Throwable {
        return new ArrayByteSource((byte[])other.read(processor));
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<byte[]> ARRAY = new BasicMetaProperty<byte[]>("array"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return ArrayByteSource.class;
            }

            public Class<byte[]> propertyType() {
                return byte[].class;
            }

            public Type propertyGenericType() {
                return byte[].class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public byte[] get(Bean bean) {
                return ((ArrayByteSource)bean).read();
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final MetaProperty<String> FILE_NAME = new BasicMetaProperty<String>("fileName"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return ArrayByteSource.class;
            }

            public Class<String> propertyType() {
                return String.class;
            }

            public Type propertyGenericType() {
                return String.class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public String get(Bean bean) {
                return ((ArrayByteSource)bean).fileName;
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"array", ARRAY, (Object)"fileName", FILE_NAME);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<ArrayByteSource> builder() {
            return new BasicImmutableBeanBuilder<ArrayByteSource>((MetaBean)this){
                private byte[] array;
                private String fileName;
                {
                    super(x0);
                    this.array = new byte[0];
                }

                public Object get(String propertyName) {
                    if (propertyName.equals(ARRAY.name())) {
                        return this.array;
                    }
                    if (propertyName.equals(FILE_NAME.name())) {
                        return this.fileName;
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<ArrayByteSource> set(String propertyName, Object value) {
                    if (propertyName.equals(ARRAY.name())) {
                        this.array = (byte[])ArgChecker.notNull(value, "value");
                    } else if (propertyName.equals(FILE_NAME.name())) {
                        this.fileName = (String)value;
                    } else {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    return this;
                }

                public ArrayByteSource build() {
                    ArrayByteSource byteSource = ArrayByteSource.ofUnsafe(this.array);
                    return this.fileName != null ? byteSource.withFileName(this.fileName) : byteSource;
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return ArrayByteSource.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }
}

