/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Strings;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.AsciiTableAlignment;
import java.util.List;

public final class AsciiTable {
    private static final String LINE_SEPARATOR = System.lineSeparator();

    public static String generate(List<String> headers, List<AsciiTableAlignment> alignments, List<? extends List<String>> cells) {
        int colCount = alignments.size();
        int rowCount = cells.size();
        ArgChecker.isTrue(headers.size() == colCount, "Number of headers {} must match number of alignments {}", headers.size(), colCount);
        int[] colLengths = new int[colCount];
        for (int colIdx = 0; colIdx < colCount; ++colIdx) {
            colLengths[colIdx] = headers.get(colIdx).length();
        }
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            List<String> row = cells.get(rowIdx);
            ArgChecker.isTrue(row.size() == colCount, "Table of cells has incorrect number of columns {} in row {}", row.size(), rowIdx);
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                colLengths[colIdx] = Math.max(colLengths[colIdx], row.get(colIdx).length());
            }
        }
        int colTotalLength = 3;
        for (int colIdx = 0; colIdx < colCount; ++colIdx) {
            colTotalLength += colLengths[colIdx] + 3;
        }
        StringBuilder buf = new StringBuilder((rowCount + 3) * colTotalLength);
        AsciiTable.writeSeparatorLine(buf, colLengths);
        AsciiTable.writeDataLine(buf, colLengths, alignments, headers);
        AsciiTable.writeSeparatorLine(buf, colLengths);
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            AsciiTable.writeDataLine(buf, colLengths, alignments, cells.get(rowIdx));
        }
        AsciiTable.writeSeparatorLine(buf, colLengths);
        return buf.toString();
    }

    private static void writeSeparatorLine(StringBuilder buf, int[] colLengths) {
        for (int colIdx = 0; colIdx < colLengths.length; ++colIdx) {
            buf.append('+');
            for (int i = 0; i < colLengths[colIdx] + 2; ++i) {
                buf.append('-');
            }
        }
        buf.append('+').append(LINE_SEPARATOR);
    }

    private static void writeDataLine(StringBuilder buf, int[] colLengths, List<AsciiTableAlignment> alignments, List<String> values) {
        for (int colIdx = 0; colIdx < colLengths.length; ++colIdx) {
            String value = Strings.nullToEmpty((String)values.get(colIdx));
            buf.append('|').append(' ').append(AsciiTable.formatValue(buf, colLengths[colIdx], alignments.get(colIdx), value)).append(' ');
        }
        buf.append('|').append(LINE_SEPARATOR);
    }

    private static String formatValue(StringBuilder buf, int colLength, AsciiTableAlignment alignment, String value) {
        if (alignment == AsciiTableAlignment.RIGHT) {
            return Strings.padStart((String)value, (int)colLength, (char)' ');
        }
        return Strings.padEnd((String)value, (int)colLength, (char)' ');
    }

    private AsciiTable() {
    }
}

