/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;

public final class IniFileOutput {
    private static final String NEW_LINE = System.lineSeparator();
    private final Appendable underlying;
    private final String newLine;
    private final boolean padSeparatorWithWhitespace;

    public static IniFileOutput standard(Appendable underlying) {
        return new IniFileOutput(underlying, NEW_LINE, true);
    }

    public static IniFileOutput standard(Appendable underlying, String newLine) {
        return new IniFileOutput(underlying, newLine, true);
    }

    public static IniFileOutput standard(Appendable underlying, boolean padSeparatorWithWhitespace) {
        return new IniFileOutput(underlying, NEW_LINE, padSeparatorWithWhitespace);
    }

    public static IniFileOutput standard(Appendable underlying, boolean padSeparatorWithWhitespace, String newLine) {
        return new IniFileOutput(underlying, newLine, padSeparatorWithWhitespace);
    }

    private IniFileOutput(Appendable underlying, String newLine, boolean padSeparatorWithWhitespace) {
        this.underlying = ArgChecker.notNull(underlying, "underlying");
        this.newLine = ArgChecker.notNull(newLine, "newLine");
        this.padSeparatorWithWhitespace = padSeparatorWithWhitespace;
    }

    public void writeSection(String sectionName, PropertySet section) {
        ArgChecker.notNull(sectionName, "sectionName");
        ArgChecker.notNull(section, "section");
        String assignment = this.padSeparatorWithWhitespace ? " = " : "=";
        try {
            this.underlying.append(IniFileOutput.formatSectionName(sectionName));
            this.underlying.append(this.newLine);
            for (Map.Entry entry : section.asMultimap().entries()) {
                this.underlying.append((CharSequence)entry.getKey());
                this.underlying.append(assignment);
                this.underlying.append((CharSequence)entry.getValue());
                this.underlying.append(this.newLine);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void writeIniFile(IniFile file) {
        for (Map.Entry entry : file.asMap().entrySet()) {
            this.writeSection((String)entry.getKey(), (PropertySet)entry.getValue());
            this.append(this.newLine);
        }
    }

    private void append(CharSequence charSequence) {
        try {
            this.underlying.append(charSequence);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static String formatSectionName(String name) {
        return Messages.format("[{}]", (Object)name);
    }
}

