/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.BeanByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicImmutableBeanBuilder;
import org.joda.beans.impl.BasicMetaBean;
import org.joda.beans.impl.BasicMetaProperty;

public final class UriByteSource
extends BeanByteSource
implements ImmutableBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private final URI uri;

    public static UriByteSource of(URI uri) {
        return new UriByteSource(uri);
    }

    public static UriByteSource of(URL url) {
        try {
            return new UriByteSource(url.toURI());
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private UriByteSource(URI uri) {
        this.uri = ArgChecker.notNull(uri, "uri");
    }

    public MetaBean metaBean() {
        return Meta.META;
    }

    @Override
    public Optional<String> getFileName() {
        String path = this.uri.getPath().toString();
        int lastSlash = path.lastIndexOf(47);
        return Optional.of(path.substring(lastSlash + 1));
    }

    public URI getUri() {
        return this.uri;
    }

    public InputStream openStream() throws IOException {
        try {
            return this.uri.toURL().openStream();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public ArrayByteSource load() {
        return new ArrayByteSource(Unchecked.wrap(() -> this.read()), this.getFileName().orElse(null));
    }

    public boolean equals(Object other) {
        if (other instanceof UriByteSource) {
            return this.uri.equals(((UriByteSource)other).uri);
        }
        return false;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public String toString() {
        return "UriByteSource[" + this.uri + "]";
    }

    static {
        MetaBean.register((MetaBean)Meta.META);
    }

    static final class Meta
    extends BasicMetaBean {
        private static final MetaBean META = new Meta();
        private static final MetaProperty<URI> PROP_URI = new BasicMetaProperty<URI>("uri"){

            public MetaBean metaBean() {
                return META;
            }

            public Class<?> declaringType() {
                return UriByteSource.class;
            }

            public Class<URI> propertyType() {
                return URI.class;
            }

            public Type propertyGenericType() {
                return URI.class;
            }

            public PropertyStyle style() {
                return PropertyStyle.IMMUTABLE;
            }

            public List<Annotation> annotations() {
                return ImmutableList.of();
            }

            public URI get(Bean bean) {
                return ((UriByteSource)bean).uri;
            }

            public void set(Bean bean, Object value) {
                throw new UnsupportedOperationException("Property cannot be written: " + this.name());
            }
        };
        private static final ImmutableMap<String, MetaProperty<?>> MAP = ImmutableMap.of((Object)"uri", PROP_URI);

        private Meta() {
        }

        public boolean isBuildable() {
            return true;
        }

        public BeanBuilder<UriByteSource> builder() {
            return new BasicImmutableBeanBuilder<UriByteSource>((MetaBean)this){
                private URI uri;

                public Object get(String propertyName) {
                    if (propertyName.equals(PROP_URI.name())) {
                        return this.uri;
                    }
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }

                public BeanBuilder<UriByteSource> set(String propertyName, Object value) {
                    if (!propertyName.equals(PROP_URI.name())) {
                        throw new NoSuchElementException("Unknown property: " + propertyName);
                    }
                    this.uri = (URI)ArgChecker.notNull(value, "value");
                    return this;
                }

                public UriByteSource build() {
                    return new UriByteSource(this.uri);
                }
            };
        }

        public Class<? extends Bean> beanType() {
            return UriByteSource.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return MAP;
        }
    }
}

