/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.result;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.FailureItem;
import com.opengamma.strata.collect.result.FailureReason;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Failure
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FailureReason reason;
    @PropertyDefinition(validate="notEmpty")
    private final String message;
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableSet<FailureItem> items;
    private static final long serialVersionUID = 1L;

    public static Failure of(FailureReason reason, String message, Object ... messageArgs) {
        String msg = Messages.format(message, messageArgs);
        return Failure.of(FailureItem.of(reason, msg, 1));
    }

    public static Failure of(FailureReason reason, Throwable cause, String message, Object ... messageArgs) {
        return Failure.of(FailureItem.of(reason, cause, message, messageArgs));
    }

    public static Failure of(FailureReason reason, Exception cause, String message, Object ... messageArgs) {
        return Failure.of(FailureItem.of(reason, cause, message, messageArgs));
    }

    public static Failure of(FailureReason reason, Throwable cause) {
        return Failure.of(FailureItem.of(reason, cause));
    }

    public static Failure of(FailureReason reason, Exception cause) {
        return Failure.of(FailureItem.of(reason, cause));
    }

    public static Failure of(FailureItem item) {
        return new Failure(item.getReason(), item.getMessage(), (Set<FailureItem>)ImmutableSet.of((Object)item));
    }

    public static Failure of(FailureItem item, FailureItem ... additionalItems) {
        return Failure.of((Collection<FailureItem>)ImmutableSet.builder().add((Object)item).add((Object[])additionalItems).build());
    }

    public static Failure of(Collection<FailureItem> items) {
        ArgChecker.notEmpty(items, "items");
        ImmutableSet itemSet = ImmutableSet.copyOf(items);
        String message = itemSet.stream().map(FailureItem::getMessage).collect(Collectors.joining(", "));
        FailureReason reason = itemSet.stream().map(FailureItem::getReason).reduce((s1, s2) -> s1 == s2 ? s1 : FailureReason.MULTIPLE).get();
        return new Failure(reason, message, (Set<FailureItem>)itemSet);
    }

    public FailureItem getFirstItem() {
        return (FailureItem)this.items.iterator().next();
    }

    public Failure mapItems(Function<FailureItem, FailureItem> function) {
        return new Failure(this.reason, this.message, (Set)this.items.stream().map(function).collect(Guavate.toImmutableSet()));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private Failure(FailureReason reason, String message, Set<FailureItem> items) {
        JodaBeanUtils.notNull((Object)reason, (String)"reason");
        JodaBeanUtils.notEmpty((String)message, (String)"message");
        JodaBeanUtils.notEmpty(items, (String)"items");
        this.reason = reason;
        this.message = message;
        this.items = ImmutableSet.copyOf(items);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FailureReason getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public ImmutableSet<FailureItem> getItems() {
        return this.items;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Failure other = (Failure)obj;
            return JodaBeanUtils.equal((Object)this.reason, (Object)other.reason) && JodaBeanUtils.equal((Object)this.message, (Object)other.message) && JodaBeanUtils.equal(this.items, other.items);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.reason);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.message);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.items);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("Failure{");
        buf.append("reason").append('=').append(JodaBeanUtils.toString((Object)this.reason)).append(',').append(' ');
        buf.append("message").append('=').append(JodaBeanUtils.toString((Object)this.message)).append(',').append(' ');
        buf.append("items").append('=').append(JodaBeanUtils.toString(this.items));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<Failure> {
        private FailureReason reason;
        private String message;
        private Set<FailureItem> items = ImmutableSet.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    return this.reason;
                }
                case 954925063: {
                    return this.message;
                }
                case 100526016: {
                    return this.items;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    this.reason = (FailureReason)newValue;
                    break;
                }
                case 954925063: {
                    this.message = (String)newValue;
                    break;
                }
                case 100526016: {
                    this.items = (Set)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Failure build() {
            return new Failure(this.reason, this.message, this.items);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("Failure.Builder{");
            buf.append("reason").append('=').append(JodaBeanUtils.toString((Object)this.reason)).append(',').append(' ');
            buf.append("message").append('=').append(JodaBeanUtils.toString((Object)this.message)).append(',').append(' ');
            buf.append("items").append('=').append(JodaBeanUtils.toString(this.items));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FailureReason> reason = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"reason", Failure.class, FailureReason.class);
        private final MetaProperty<String> message = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"message", Failure.class, String.class);
        private final MetaProperty<ImmutableSet<FailureItem>> items = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"items", Failure.class, ImmutableSet.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"reason", "message", "items"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    return this.reason;
                }
                case 954925063: {
                    return this.message;
                }
                case 100526016: {
                    return this.items;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Failure> builder() {
            return new Builder();
        }

        public Class<? extends Failure> beanType() {
            return Failure.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FailureReason> reason() {
            return this.reason;
        }

        public MetaProperty<String> message() {
            return this.message;
        }

        public MetaProperty<ImmutableSet<FailureItem>> items() {
            return this.items;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    return ((Failure)bean).getReason();
                }
                case 954925063: {
                    return ((Failure)bean).getMessage();
                }
                case 100526016: {
                    return ((Failure)bean).getItems();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

