/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.tuple.ObjIntPair;
import com.opengamma.strata.collect.tuple.Pair;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Guavate {
    private Guavate() {
    }

    @SafeVarargs
    public static <T> ImmutableList<T> concatToList(Iterable<? extends T> ... iterables) {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable[])iterables));
    }

    @SafeVarargs
    public static <T> ImmutableSet<T> concatToSet(Iterable<? extends T> ... iterables) {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable[])iterables));
    }

    public static <K, V> ImmutableMap<K, V> combineMaps(Map<? extends K, ? extends V> first, Map<? extends K, ? extends V> second) {
        return Stream.concat(first.entrySet().stream(), second.entrySet().stream()).collect(Guavate.entriesToImmutableMap());
    }

    public static <K, V> ImmutableMap<K, V> combineMaps(Map<? extends K, ? extends V> first, Map<? extends K, ? extends V> second, BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return Stream.concat(first.entrySet().stream(), second.entrySet().stream()).collect(Guavate.entriesToImmutableMap(mergeFn));
    }

    public static <T> Optional<T> tryCatchToOptional(Supplier<T> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (RuntimeException ex) {
            return Optional.empty();
        }
    }

    @SafeVarargs
    public static <T> Optional<T> firstNonEmpty(Supplier<Optional<? extends T>> ... suppliers) {
        for (Supplier<Optional<Optional<T>>> supplier : suppliers) {
            Optional<T> result = supplier.get();
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @SafeVarargs
    public static <T> Optional<T> firstNonEmpty(Optional<? extends T> ... optionals) {
        for (Optional<T> optional : optionals) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static <T> Optional<T> first(Iterable<T> iterable) {
        Iterator<T> it = iterable.iterator();
        return it.hasNext() ? Optional.of(it.next()) : Optional.empty();
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <T> Iterable<T> in(Stream<T> stream) {
        return stream::iterator;
    }

    public static <T> Iterable<T> inOptional(Optional<T> optional) {
        if (optional.isPresent()) {
            return ImmutableList.of(optional.get());
        }
        return ImmutableList.of();
    }

    public static <T> Stream<ObjIntPair<T>> zipWithIndex(Stream<T> stream) {
        Spliterator split1 = stream.spliterator();
        final Iterator it1 = Spliterators.iterator(split1);
        Iterator it = new Iterator<ObjIntPair<T>>(){
            private int index;

            @Override
            public boolean hasNext() {
                return it1.hasNext();
            }

            @Override
            public ObjIntPair<T> next() {
                return ObjIntPair.of(it1.next(), this.index++);
            }
        };
        Spliterator split = Spliterators.spliterator(it, split1.getExactSizeIfKnown(), split1.characteristics());
        return StreamSupport.stream(split, false);
    }

    public static <A, B> Stream<Pair<A, B>> zip(Stream<A> stream1, Stream<B> stream2) {
        return Guavate.zip(stream1, stream2, (a, b) -> Pair.of(a, b));
    }

    static <A, B, R> Stream<R> zip(Stream<A> stream1, Stream<B> stream2, final BiFunction<A, B, R> zipper) {
        Spliterator split1 = stream1.spliterator();
        Spliterator split2 = stream2.spliterator();
        int characteristics = split1.characteristics() & split2.characteristics() & 0xFFFFFFFA;
        long size = Math.min(split1.getExactSizeIfKnown(), split2.getExactSizeIfKnown());
        final Iterator it1 = Spliterators.iterator(split1);
        final Iterator it2 = Spliterators.iterator(split2);
        Iterator it = new Iterator<R>(){

            @Override
            public boolean hasNext() {
                return it1.hasNext() && it2.hasNext();
            }

            @Override
            public R next() {
                return zipper.apply(it1.next(), it2.next());
            }
        };
        Spliterator split = Spliterators.spliterator(it, size, characteristics);
        return StreamSupport.stream(split, false);
    }

    public static <R> Predicate<R> not(Predicate<R> predicate) {
        return predicate.negate();
    }

    public static <T> BinaryOperator<T> ensureOnlyOne() {
        return (a, b) -> {
            throw new IllegalArgumentException(Messages.format("Multiple values found where only one was expected: {} and {}", a, b));
        };
    }

    public static <T, R extends T> Function<T, R> casting(Class<R> cls) {
        return input -> cls.cast(input);
    }

    public static <T, R extends T> Function<T, Stream<R>> filtering(Class<R> cls) {
        return input -> cls.isInstance(input) ? Stream.of(cls.cast(input)) : Stream.empty();
    }

    public static <T> Function<Optional<T>, Stream<T>> filteringOptional() {
        return opt -> opt.isPresent() ? Stream.of(opt.get()) : Stream.empty();
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toImmutableList() {
        return Collector.of(ImmutableList.Builder::new, ImmutableList.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, ImmutableList<ImmutableList<T>>> splittingBySize(int size) {
        return Collectors.collectingAndThen(Collectors.collectingAndThen(Guavate.toImmutableList(), objects -> Lists.partition((List)objects, (int)size)), Guavate::toImmutables);
    }

    private static <T> ImmutableList<ImmutableList<T>> toImmutables(List<List<T>> lists) {
        return lists.stream().map(ImmutableList::copyOf).collect(Guavate.toImmutableList());
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toImmutableSet() {
        return Collector.of(ImmutableSet.Builder::new, ImmutableSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T extends Comparable<?>> Collector<T, ImmutableSortedSet.Builder<T>, ImmutableSortedSet<T>> toImmutableSortedSet() {
        return Collector.of(ImmutableSortedSet::naturalOrder, ImmutableSortedSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSortedSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ImmutableSortedSet.Builder<T>, ImmutableSortedSet<T>> toImmutableSortedSet(Comparator<? super T> comparator) {
        return Collector.of(() -> new ImmutableSortedSet.Builder(comparator), ImmutableSortedSet.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableSortedSet.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ImmutableMultiset.Builder<T>, ImmutableMultiset<T>> toImmutableMultiset() {
        return Collector.of(ImmutableMultiset.Builder::new, ImmutableMultiset.Builder::add, (l, r) -> l.addAll((Iterable)r.build()), ImmutableMultiset.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K> Collector<T, ?, ImmutableMap<K, T>> toImmutableMap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableMap(keyExtractor, Function.identity());
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableMap.Builder::new, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Map)r.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, V> Collector<T, Map<K, V>, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor, BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return Collector.of(LinkedHashMap::new, (map, val) -> map.merge(keyExtractor.apply(val), valueExtractor.apply(val), mergeFn), (m1, m2) -> Guavate.mergeMaps(m1, m2, mergeFn), map -> ImmutableMap.copyOf((Map)map), Collector.Characteristics.UNORDERED);
    }

    public static <T, K extends Comparable<?>> Collector<T, ?, ImmutableSortedMap<K, T>> toImmutableSortedMap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableSortedMap(keyExtractor, Function.identity());
    }

    public static <T, K extends Comparable<?>, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableSortedMap::naturalOrder, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Map)r.build()), ImmutableSortedMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K extends Comparable<?>, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor, BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return Collector.of(TreeMap::new, (map, val) -> map.merge(keyExtractor.apply(val), valueExtractor.apply(val), mergeFn), (m1, m2) -> Guavate.mergeMaps(m1, m2, mergeFn), map -> ImmutableSortedMap.copyOfSorted((SortedMap)map), Collector.Characteristics.UNORDERED);
    }

    public static <T, K> Collector<T, ?, ImmutableListMultimap<K, T>> toImmutableListMultimap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableListMultimap(keyExtractor, Function.identity());
    }

    public static <T, K, V> Collector<T, ?, ImmutableListMultimap<K, V>> toImmutableListMultimap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableListMultimap.Builder::new, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Multimap)r.build()), ImmutableListMultimap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K> Collector<T, ?, ImmutableSetMultimap<K, T>> toImmutableSetMultimap(Function<? super T, ? extends K> keyExtractor) {
        return Guavate.toImmutableSetMultimap(keyExtractor, Function.identity());
    }

    public static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap(Function<? super T, ? extends K> keyExtractor, Function<? super T, ? extends V> valueExtractor) {
        return Collector.of(ImmutableSetMultimap.Builder::new, (builder, val) -> builder.put(keyExtractor.apply(val), valueExtractor.apply(val)), (l, r) -> l.putAll((Multimap)r.build()), ImmutableSetMultimap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, ImmutableMap<K, V>> entriesToImmutableMap() {
        return Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, ImmutableMap<K, V>> entriesToImmutableMap(BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, mergeFn);
    }

    public static <K, V> Collector<Pair<? extends K, ? extends V>, ?, ImmutableMap<K, V>> pairsToImmutableMap() {
        return Guavate.toImmutableMap(Pair::getFirst, Pair::getSecond);
    }

    private static <K, V, M extends Map<K, V>> M mergeMaps(M map1, Map<K, V> map2, BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            V existingValue = map1.get(entry.getKey());
            if (existingValue == null) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            map1.put(entry.getKey(), mergeFn.apply(existingValue, entry.getValue()));
        }
        return map1;
    }

    public static <T> CompletableFuture<List<T>> combineFuturesAsList(List<? extends CompletableFuture<? extends T>> futures) {
        int size = futures.size();
        CompletableFuture[] futuresArray = futures.toArray(new CompletableFuture[size]);
        return CompletableFuture.allOf(futuresArray).thenApply(unused -> {
            ArrayList builder = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                builder.add(futuresArray[i].join());
            }
            return builder;
        });
    }

    public static <T, S extends CompletableFuture<? extends T>> Collector<S, ?, CompletableFuture<List<T>>> toCombinedFuture() {
        return Collectors.collectingAndThen(Guavate.toImmutableList(), Guavate::combineFuturesAsList);
    }

    public static <K, V, F extends CompletableFuture<? extends V>> CompletableFuture<Map<K, V>> combineFuturesAsMap(Map<? extends K, ? extends F> futures) {
        int size = futures.size();
        Object[] keyArray = new Object[size];
        CompletableFuture[] futuresArray = new CompletableFuture[size];
        int index = 0;
        for (Map.Entry<K, F> entry : futures.entrySet()) {
            keyArray[index] = entry.getKey();
            futuresArray[index] = (CompletableFuture)entry.getValue();
            ++index;
        }
        return CompletableFuture.allOf(futuresArray).thenApply(unused -> {
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                builder.put(keyArray[i], futuresArray[i].join());
            }
            return builder.build();
        });
    }

    public static <K, V, F extends CompletableFuture<? extends V>> Collector<Map.Entry<? extends K, ? extends F>, ?, CompletableFuture<Map<K, V>>> toCombinedFutureMap() {
        return Collectors.collectingAndThen(Guavate.entriesToImmutableMap(), Guavate::combineFuturesAsMap);
    }

    public static <T> CompletableFuture<T> poll(ScheduledExecutorService executorService, Duration initialDelay, Duration frequency, Supplier<T> pollingTask) {
        CompletableFuture result = new CompletableFuture();
        Runnable decoratedPollingTask = () -> Guavate.pollTask(pollingTask, result);
        ScheduledFuture<?> scheduledTask = executorService.scheduleAtFixedRate(decoratedPollingTask, initialDelay.toMillis(), frequency.toMillis(), TimeUnit.MILLISECONDS);
        return result.whenComplete((r, ex) -> scheduledTask.cancel(true));
    }

    private static <T> void pollTask(Supplier<T> pollingTask, CompletableFuture<T> resultFuture) {
        try {
            T result = pollingTask.get();
            if (result != null) {
                resultFuture.complete(result);
            }
        }
        catch (RuntimeException ex) {
            resultFuture.completeExceptionally(ex);
        }
    }

    public static ThreadFactoryBuilder namedThreadFactory() {
        return Guavate.namedThreadFactory(Guavate.callerClass(3).getSimpleName());
    }

    public static ThreadFactoryBuilder namedThreadFactory(String threadNamePrefix) {
        return new ThreadFactoryBuilder().setNameFormat(threadNamePrefix + "-%d");
    }

    public static Class<?> callerClass(int callStackDepth) {
        return CallerClassSecurityManager.INSTANCE.callerClass(callStackDepth);
    }

    static class CallerClassSecurityManager
    extends SecurityManager {
        private static final CallerClassSecurityManager INSTANCE = new CallerClassSecurityManager();

        CallerClassSecurityManager() {
        }

        Class<?> callerClass(int callStackDepth) {
            return this.getClassContext()[callStackDepth];
        }
    }
}

