/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Streams;
import com.opengamma.strata.collect.Guavate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class MapStream<K, V>
implements Stream<Map.Entry<K, V>> {
    private final Stream<Map.Entry<K, V>> underlying;

    public static <K, V> MapStream<K, V> of(Map<K, V> map) {
        return new MapStream<K, V>(map.entrySet().stream());
    }

    public static <K, V> MapStream<K, V> of(Multimap<K, V> multimap) {
        return new MapStream<K, V>(multimap.entries().stream());
    }

    public static <V> MapStream<V, V> of(Collection<V> collection) {
        return MapStream.of(collection.stream());
    }

    public static <V> MapStream<V, V> of(Stream<V> stream) {
        return MapStream.of(stream, (? super V key) -> key);
    }

    public static <K, V> MapStream<K, V> of(Collection<V> collection, Function<? super V, ? extends K> keyFunction) {
        return MapStream.of(collection.stream(), keyFunction);
    }

    public static <T, K, V> MapStream<K, V> of(Collection<T> collection, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return MapStream.of(collection.stream(), keyFunction, valueFunction);
    }

    public static <K, V> MapStream<K, V> of(Stream<V> stream, Function<? super V, ? extends K> keyFunction) {
        return new MapStream<K, V>(stream.map((? super T v) -> Guavate.entry(keyFunction.apply((Object)v), v)));
    }

    public static <T, K, V> MapStream<K, V> of(Stream<T> stream, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        return new MapStream<K, V>(stream.map((? super T item) -> Guavate.entry(keyFunction.apply(item), valueFunction.apply(item))));
    }

    public static <K, V> MapStream<K, V> zip(Stream<K> keyStream, Stream<V> valueStream) {
        return new MapStream<K, V>(Guavate.zip(keyStream, valueStream, Guavate::entry));
    }

    public static <V> MapStream<Integer, V> zipWithIndex(Stream<V> stream) {
        Stream zipped = Streams.mapWithIndex(stream, (value, index) -> Guavate.entry(Math.toIntExact(index), value));
        return new MapStream(zipped);
    }

    public static <K, V> MapStream<K, V> empty() {
        return new MapStream<K, V>(Stream.empty());
    }

    public static <K, V> MapStream<K, V> concat(MapStream<? extends K, ? extends V> a, MapStream<? extends K, ? extends V> b) {
        MapStream<K, V> kvMapStream = new MapStream<K, V>(Streams.concat((Stream[])new Stream[]{a, b}));
        return kvMapStream;
    }

    private MapStream(Stream<Map.Entry<K, V>> underlying) {
        this.underlying = underlying;
    }

    public Stream<K> keys() {
        return this.underlying.map(Map.Entry::getKey);
    }

    public Stream<V> values() {
        return this.underlying.map(Map.Entry::getValue);
    }

    public MapStream<K, V> filter(BiFunction<? super K, ? super V, Boolean> predicate) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> (Boolean)predicate.apply((Object)e.getKey(), (Object)e.getValue())));
    }

    public MapStream<K, V> filterKeys(Predicate<? super K> predicate) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> predicate.test((Object)e.getKey())));
    }

    public <R> MapStream<R, V> filterKeys(Class<R> castToClass) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> castToClass.isInstance(e.getKey())).map((? super T e) -> Guavate.entry(castToClass.cast(e.getKey()), e.getValue())));
    }

    public MapStream<K, V> filterValues(Predicate<? super V> predicate) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> predicate.test((Object)e.getValue())));
    }

    public <R> MapStream<K, R> filterValues(Class<R> castToClass) {
        return MapStream.wrap(this.underlying.filter((? super T e) -> castToClass.isInstance(e.getValue())).map((? super T e) -> Guavate.entry(e.getKey(), castToClass.cast(e.getValue()))));
    }

    public <R> MapStream<R, V> mapKeys(Function<? super K, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> Guavate.entry(mapper.apply((Object)e.getKey()), e.getValue())));
    }

    public <R> MapStream<R, V> mapKeys(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> Guavate.entry(mapper.apply((Object)e.getKey(), (Object)e.getValue()), e.getValue())));
    }

    public <R> MapStream<K, R> mapValues(Function<? super V, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> Guavate.entry(e.getKey(), mapper.apply((Object)e.getValue()))));
    }

    public <R> MapStream<K, R> mapValues(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return MapStream.wrap(this.underlying.map((? super T e) -> Guavate.entry(e.getKey(), mapper.apply((Object)e.getKey(), (Object)e.getValue()))));
    }

    public <R> Stream<R> map(BiFunction<? super K, ? super V, ? extends R> mapper) {
        return this.underlying.map((? super T e) -> mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public DoubleStream mapToDouble(ToDoubleBiFunction<? super K, ? super V> mapper) {
        return this.underlying.mapToDouble((? super T e) -> mapper.applyAsDouble((Object)e.getKey(), (Object)e.getValue()));
    }

    public IntStream mapToInt(ToIntBiFunction<? super K, ? super V> mapper) {
        return this.underlying.mapToInt((? super T e) -> mapper.applyAsInt((Object)e.getKey(), (Object)e.getValue()));
    }

    public <R> MapStream<R, V> flatMapKeys(Function<? super K, Stream<R>> mapper) {
        return MapStream.wrap(this.underlying.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey())).map((? super T newKey) -> Guavate.entry(newKey, e.getValue()))));
    }

    public <R> MapStream<R, V> flatMapKeys(BiFunction<? super K, ? super V, Stream<R>> mapper) {
        return MapStream.wrap(this.underlying.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue())).map((? super T newKey) -> Guavate.entry(newKey, e.getValue()))));
    }

    public <R> MapStream<K, R> flatMapValues(Function<? super V, Stream<R>> mapper) {
        return MapStream.wrap(this.underlying.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getValue())).map((? super T newValue) -> Guavate.entry(e.getKey(), newValue))));
    }

    public <R> MapStream<K, R> flatMapValues(BiFunction<? super K, ? super V, Stream<R>> mapper) {
        return MapStream.wrap(this.underlying.flatMap((? super T e) -> ((Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue())).map((? super T newValue) -> Guavate.entry(e.getKey(), newValue))));
    }

    public <R> Stream<R> flatMap(BiFunction<? super K, ? super V, Stream<R>> mapper) {
        return this.underlying.flatMap((? super T e) -> (Stream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public DoubleStream flatMapToDouble(BiFunction<? super K, ? super V, ? extends DoubleStream> mapper) {
        return this.underlying.flatMapToDouble((? super T e) -> (DoubleStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public IntStream flatMapToInt(BiFunction<? super K, ? super V, ? extends IntStream> mapper) {
        return this.underlying.flatMapToInt((? super T e) -> (IntStream)mapper.apply((Object)e.getKey(), (Object)e.getValue()));
    }

    public MapStream<K, V> sortedKeys() {
        Comparator comparator = Comparator.naturalOrder();
        return MapStream.wrap(this.underlying.sorted((e1, e2) -> comparator.compare(e1.getKey(), e2.getKey())));
    }

    public MapStream<K, V> sortedKeys(Comparator<? super K> comparator) {
        return MapStream.wrap(this.underlying.sorted((e1, e2) -> comparator.compare((Object)e1.getKey(), (Object)e2.getKey())));
    }

    public MapStream<K, V> sortedValues() {
        Comparator comparator = Comparator.naturalOrder();
        return MapStream.wrap(this.underlying.sorted((e1, e2) -> comparator.compare(e1.getValue(), e2.getValue())));
    }

    public MapStream<K, V> sortedValues(Comparator<? super V> comparator) {
        return MapStream.wrap(this.underlying.sorted((e1, e2) -> comparator.compare((Object)e1.getValue(), (Object)e2.getValue())));
    }

    public Optional<Map.Entry<K, V>> minKeys(Comparator<? super K> comparator) {
        return this.underlying.min((e1, e2) -> comparator.compare((Object)e1.getKey(), (Object)e2.getKey()));
    }

    public Optional<Map.Entry<K, V>> minValues(Comparator<? super V> comparator) {
        return this.underlying.min((e1, e2) -> comparator.compare((Object)e1.getValue(), (Object)e2.getValue()));
    }

    public Optional<Map.Entry<K, V>> maxKeys(Comparator<? super K> comparator) {
        return this.underlying.max((e1, e2) -> comparator.compare((Object)e1.getKey(), (Object)e2.getKey()));
    }

    public Optional<Map.Entry<K, V>> maxValues(Comparator<? super V> comparator) {
        return this.underlying.max((e1, e2) -> comparator.compare((Object)e1.getValue(), (Object)e2.getValue()));
    }

    public boolean anyMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.underlying.anyMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean allMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.underlying.allMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public boolean noneMatch(BiPredicate<? super K, ? super V> predicate) {
        return this.underlying.noneMatch((? super T e) -> predicate.test((Object)e.getKey(), (Object)e.getValue()));
    }

    public ImmutableMap<K, V> toMap() {
        return this.underlying.collect(Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ImmutableMap<K, V> toMap(BiFunction<? super V, ? super V, ? extends V> mergeFn) {
        return this.underlying.collect(Guavate.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, mergeFn));
    }

    public ImmutableMap<K, List<V>> toMapGrouping() {
        return this.toMapGrouping(Collectors.toList());
    }

    public <A, R> ImmutableMap<K, R> toMapGrouping(Collector<? super V, A, R> valueCollector) {
        return this.underlying.collect(Collectors.collectingAndThen(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, valueCollector)), ImmutableMap::copyOf));
    }

    public ImmutableListMultimap<K, V> toListMultimap() {
        return this.underlying.collect(Guavate.toImmutableListMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public ImmutableSetMultimap<K, V> toSetMultimap() {
        return this.underlying.collect(Guavate.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.underlying.forEach((? super T e) -> action.accept((Object)e.getKey(), (Object)e.getValue()));
    }

    public MapStream<K, V> filter(Predicate<? super Map.Entry<K, V>> predicate) {
        return MapStream.wrap(this.underlying.filter(predicate));
    }

    @Override
    public <R> Stream<R> map(Function<? super Map.Entry<K, V>, ? extends R> mapper) {
        return this.underlying.map(mapper);
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super Map.Entry<K, V>> mapper) {
        return this.underlying.mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super Map.Entry<K, V>> mapper) {
        return this.underlying.mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super Map.Entry<K, V>> mapper) {
        return this.underlying.mapToDouble(mapper);
    }

    @Override
    public <R> Stream<R> flatMap(Function<? super Map.Entry<K, V>, ? extends Stream<? extends R>> mapper) {
        return this.underlying.flatMap(mapper);
    }

    @Override
    public IntStream flatMapToInt(Function<? super Map.Entry<K, V>, ? extends IntStream> mapper) {
        return this.underlying.flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super Map.Entry<K, V>, ? extends LongStream> mapper) {
        return this.underlying.flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super Map.Entry<K, V>, ? extends DoubleStream> mapper) {
        return this.underlying.flatMapToDouble(mapper);
    }

    public MapStream<K, V> distinct() {
        return MapStream.wrap(this.underlying.distinct());
    }

    public MapStream<K, V> sorted() {
        return MapStream.wrap(this.underlying.sorted());
    }

    public MapStream<K, V> sorted(Comparator<? super Map.Entry<K, V>> comparator) {
        return MapStream.wrap(this.underlying.sorted(comparator));
    }

    public MapStream<K, V> peek(Consumer<? super Map.Entry<K, V>> action) {
        return MapStream.wrap(this.underlying.peek(action));
    }

    public MapStream<K, V> limit(long maxSize) {
        return MapStream.wrap(this.underlying.limit(maxSize));
    }

    public MapStream<K, V> skip(long n) {
        return MapStream.wrap(this.underlying.skip(n));
    }

    @Override
    public void forEach(Consumer<? super Map.Entry<K, V>> action) {
        this.underlying.forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super Map.Entry<K, V>> action) {
        this.underlying.forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.underlying.toArray(generator);
    }

    @Override
    public Map.Entry<K, V> reduce(Map.Entry<K, V> identity, BinaryOperator<Map.Entry<K, V>> accumulator) {
        return this.underlying.reduce(identity, accumulator);
    }

    @Override
    public Optional<Map.Entry<K, V>> reduce(BinaryOperator<Map.Entry<K, V>> accumulator) {
        return this.underlying.reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super Map.Entry<K, V>, U> accumulator, BinaryOperator<U> combiner) {
        return this.underlying.reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super Map.Entry<K, V>> accumulator, BiConsumer<R, R> combiner) {
        return this.underlying.collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super Map.Entry<K, V>, A, R> collector) {
        return this.underlying.collect(collector);
    }

    @Override
    public Optional<Map.Entry<K, V>> min(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.underlying.min(comparator);
    }

    @Override
    public Optional<Map.Entry<K, V>> max(Comparator<? super Map.Entry<K, V>> comparator) {
        return this.underlying.max(comparator);
    }

    @Override
    public long count() {
        return this.underlying.count();
    }

    @Override
    public boolean anyMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.underlying.anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.underlying.allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super Map.Entry<K, V>> predicate) {
        return this.underlying.noneMatch(predicate);
    }

    @Override
    public Optional<Map.Entry<K, V>> findFirst() {
        return this.underlying.findFirst();
    }

    @Override
    public Optional<Map.Entry<K, V>> findAny() {
        return this.underlying.findAny();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public Spliterator<Map.Entry<K, V>> spliterator() {
        return this.underlying.spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.underlying.isParallel();
    }

    @Override
    public MapStream<K, V> sequential() {
        return MapStream.wrap((Stream)this.underlying.sequential());
    }

    @Override
    public MapStream<K, V> parallel() {
        return MapStream.wrap((Stream)this.underlying.parallel());
    }

    @Override
    public MapStream<K, V> unordered() {
        return MapStream.wrap((Stream)this.underlying.unordered());
    }

    @Override
    public MapStream<K, V> onClose(Runnable closeHandler) {
        return MapStream.wrap((Stream)this.underlying.onClose(closeHandler));
    }

    @Override
    public void close() {
        this.underlying.close();
    }

    private static <K, V> MapStream<K, V> wrap(Stream<Map.Entry<K, V>> underlying) {
        return new MapStream<K, V>(underlying);
    }
}

