/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.UnicodeBom;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.joda.beans.ImmutableBean;

public abstract class BeanByteSource
extends ByteSource
implements ImmutableBean {
    protected BeanByteSource() {
    }

    public Optional<String> getFileName() {
        return Optional.empty();
    }

    public String getFileNameOrThrow() {
        return this.getFileName().orElseThrow(() -> new IllegalArgumentException("No file name present on byte source"));
    }

    public boolean isEmpty() {
        try {
            return super.isEmpty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public long size() {
        try {
            return super.size();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public byte[] read() {
        try {
            return super.read();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String readUtf8() {
        return new String(this.read(), StandardCharsets.UTF_8);
    }

    public String readUtf8UsingBom() {
        return UnicodeBom.toString(this.read());
    }

    public CharSource asCharSourceUtf8() {
        return this.asCharSource(StandardCharsets.UTF_8);
    }

    public CharSource asCharSourceUtf8UsingBom() {
        return UnicodeBom.toCharSource(this);
    }

    public ArrayByteSource load() {
        return ArrayByteSource.from(this);
    }

    public HashCode hash(HashFunction hashFunction) {
        try {
            return super.hash(hashFunction);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ArrayByteSource toHash(HashFunction hashFunction) {
        return ArrayByteSource.ofUnsafe(this.hash(hashFunction).asBytes());
    }

    public String toHashString(HashFunction hashFunction) {
        return this.hash(hashFunction).toString();
    }

    public ArrayByteSource toBase64() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = this.openBufferedStream();
             OutputStream out = Base64.getEncoder().wrap(baos);){
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return ArrayByteSource.ofUnsafe(baos.toByteArray());
    }

    public String toBase64String() {
        return this.toBase64().readUtf8();
    }
}

