/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.io.CharSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.PropertySet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class IniFile {
    private final ImmutableMap<String, PropertySet> sectionMap;

    public static IniFile of(CharSource source) {
        ArgChecker.notNull(source, "source");
        ImmutableList lines = Unchecked.wrap(() -> source.readLines());
        ImmutableMap<String, ImmutableListMultimap<String, String>> parsedIni = IniFile.parse((ImmutableList<String>)lines);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        parsedIni.forEach((sectionName, sectionData) -> builder.put(sectionName, (Object)PropertySet.of((Multimap<String, String>)sectionData)));
        return new IniFile((ImmutableMap<String, PropertySet>)builder.build());
    }

    private static ImmutableMap<String, ImmutableListMultimap<String, String>> parse(ImmutableList<String> lines) {
        LinkedHashMap<String, ImmutableListMultimap.Builder> ini = new LinkedHashMap<String, ImmutableListMultimap.Builder>();
        ImmutableListMultimap.Builder currentSection = null;
        int lineNum = 0;
        for (String line : lines) {
            String value;
            ++lineNum;
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
            if (line.startsWith("[") && line.endsWith("]")) {
                String sectionName = line.substring(1, line.length() - 1).trim();
                if (ini.containsKey(sectionName)) {
                    throw new IllegalArgumentException("Invalid INI file, duplicate section not allowed, line " + lineNum);
                }
                currentSection = ImmutableListMultimap.builder();
                ini.put(sectionName, currentSection);
                continue;
            }
            if (currentSection == null) {
                throw new IllegalArgumentException("Invalid INI file, properties must be within a [section], line " + lineNum);
            }
            int equalsPosition = line.indexOf(" = ");
            equalsPosition = equalsPosition < 0 ? line.indexOf(61) : equalsPosition + 1;
            String key = equalsPosition < 0 ? line.trim() : line.substring(0, equalsPosition).trim();
            String string = value = equalsPosition < 0 ? "" : line.substring(equalsPosition + 1).trim();
            if (key.length() == 0) {
                throw new IllegalArgumentException("Invalid INI file, empty key, line " + lineNum);
            }
            currentSection.put((Object)key, (Object)value);
        }
        return MapStream.of(ini).mapValues(b -> b.build()).toMap();
    }

    public static IniFile of(Map<String, PropertySet> sectionMap) {
        return new IniFile((ImmutableMap<String, PropertySet>)ImmutableMap.copyOf(sectionMap));
    }

    private IniFile(ImmutableMap<String, PropertySet> sectionMap) {
        this.sectionMap = sectionMap;
    }

    public ImmutableSet<String> sections() {
        return this.sectionMap.keySet();
    }

    public ImmutableMap<String, PropertySet> asMap() {
        return this.sectionMap;
    }

    public boolean contains(String name) {
        ArgChecker.notNull(name, "name");
        return this.sectionMap.containsKey((Object)name);
    }

    public PropertySet section(String name) {
        ArgChecker.notNull(name, "name");
        if (!this.contains(name)) {
            throw new IllegalArgumentException("Unknown INI file section: " + name);
        }
        return (PropertySet)this.sectionMap.get((Object)name);
    }

    public Optional<PropertySet> findSection(String name) {
        ArgChecker.notNull(name, "name");
        return Optional.ofNullable(this.sectionMap.get((Object)name));
    }

    public IniFile combinedWith(IniFile other) {
        ArgChecker.notNull(other, "other");
        return IniFile.of(MapStream.concat(MapStream.of(this.sectionMap), MapStream.of(other.sectionMap)).toMap(PropertySet::combinedWith));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IniFile) {
            return this.sectionMap.equals(((IniFile)obj).sectionMap);
        }
        return false;
    }

    public int hashCode() {
        return this.sectionMap.hashCode();
    }

    public String toString() {
        return this.sectionMap.toString();
    }
}

