/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.result;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.tuple.Pair;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FailureItem
implements ImmutableBean,
Serializable {
    public static final String EXCEPTION_MESSAGE_ATTRIBUTE = "exceptionMessage";
    private static final String FAILURE_EXCEPTION = "com.opengamma.strata.collect.result.FailureItem: ";
    private static final Interner<String> INTERNER = Interners.newWeakInterner();
    @PropertyDefinition(validate="notNull")
    private final FailureReason reason;
    @PropertyDefinition(validate="notEmpty")
    private final String message;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<String, String> attributes;
    @PropertyDefinition(validate="notNull")
    private final String stackTrace;
    @PropertyDefinition(get="optional")
    private final Class<? extends Throwable> causeType;
    private static final long serialVersionUID = 1L;

    public static FailureItem of(FailureReason reason, String message, Object ... messageArgs) {
        Pair<String, Map<String, String>> msg = Messages.formatWithAttributes(message, messageArgs);
        return FailureItem.of(reason, msg.getFirst(), msg.getSecond());
    }

    static FailureItem of(FailureReason reason, String message, int skipFrames) {
        ArgChecker.notNull(reason, "reason");
        ArgChecker.notEmpty(message, "message");
        String stackTrace = FailureItem.localGetStackTraceAsString(message, skipFrames);
        return new FailureItem(reason, message, (Map<String, String>)ImmutableMap.of(), stackTrace, null);
    }

    private static FailureItem of(FailureReason reason, String message, Map<String, String> attributes) {
        ArgChecker.notNull(reason, "reason");
        ArgChecker.notEmpty(message, "message");
        String stackTrace = FailureItem.localGetStackTraceAsString(message, 1);
        return new FailureItem(reason, message, attributes, stackTrace, null);
    }

    private static String localGetStackTraceAsString(String message, int skipFrames) {
        StringBuilder builder = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        builder.append(FAILURE_EXCEPTION).append(message).append("\n");
        for (int i = skipFrames + 3; i < stackTrace.length; ++i) {
            builder.append("\tat ").append(stackTrace[i]).append("\n");
        }
        return builder.toString();
    }

    public static FailureItem of(FailureReason reason, Throwable cause) {
        ArgChecker.notNull(reason, "reason");
        ArgChecker.notNull(cause, "cause");
        String causeMessage = cause.getMessage();
        String message = Strings.isNullOrEmpty((String)causeMessage) ? cause.getClass().getSimpleName() : causeMessage;
        return FailureItem.of(reason, cause, message, new Object[0]);
    }

    public static FailureItem of(FailureReason reason, Throwable cause, String message, Object ... messageArgs) {
        ArgChecker.notNull(reason, "reason");
        ArgChecker.notNull(cause, "cause");
        Pair<String, Map<String, String>> msg = Messages.formatWithAttributes(message, messageArgs);
        String stackTrace = Throwables.getStackTraceAsString((Throwable)cause).replace(System.lineSeparator(), "\n");
        FailureItem base = new FailureItem(reason, msg.getFirst(), msg.getSecond(), stackTrace, cause.getClass());
        String causeMessage = cause.getMessage();
        if (!base.getAttributes().containsKey((Object)EXCEPTION_MESSAGE_ATTRIBUTE) && !Strings.isNullOrEmpty((String)causeMessage)) {
            return base.withAttribute(EXCEPTION_MESSAGE_ATTRIBUTE, causeMessage);
        }
        return base;
    }

    @ImmutableConstructor
    private FailureItem(FailureReason reason, String message, Map<String, String> attributes, String stackTrace, Class<? extends Throwable> causeType) {
        this.attributes = ImmutableMap.copyOf(attributes);
        JodaBeanUtils.notNull((Object)reason, (String)"reason");
        JodaBeanUtils.notEmpty((String)message, (String)"message");
        JodaBeanUtils.notNull((Object)stackTrace, (String)"stackTrace");
        this.reason = reason;
        this.message = message;
        this.stackTrace = (String)INTERNER.intern((Object)stackTrace);
        this.causeType = causeType;
    }

    public FailureItem withAttribute(String key, String value) {
        HashMap<String, String> attributes = new HashMap<String, String>((Map<String, String>)this.attributes);
        attributes.put(key, value);
        return new FailureItem(this.reason, this.message, attributes, this.stackTrace, this.causeType);
    }

    public FailureItem withAttributes(Map<String, String> attributes) {
        HashMap<String, String> newAttributes = new HashMap<String, String>((Map<String, String>)this.attributes);
        newAttributes.putAll(attributes);
        return new FailureItem(this.reason, this.message, newAttributes, this.stackTrace, this.causeType);
    }

    public FailureItem mapMessage(Function<String, String> function) {
        return new FailureItem(this.reason, function.apply(this.message), (Map<String, String>)this.attributes, this.stackTrace, this.causeType);
    }

    public String toString() {
        String firstLine;
        if (this.stackTrace.startsWith(FAILURE_EXCEPTION)) {
            return this.reason + ": " + this.message;
        }
        int endLine = this.stackTrace.indexOf("\n");
        String string = firstLine = endLine < 0 ? this.stackTrace : this.stackTrace.substring(0, endLine);
        if (firstLine.endsWith(": " + this.message)) {
            return this.reason + ": " + this.message + ": " + firstLine.substring(0, firstLine.length() - this.message.length() - 2);
        }
        return this.reason + ": " + this.message + ": " + firstLine;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FailureReason getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Optional<Class<? extends Throwable>> getCauseType() {
        return Optional.ofNullable(this.causeType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FailureItem other = (FailureItem)obj;
            return JodaBeanUtils.equal((Object)this.reason, (Object)other.reason) && JodaBeanUtils.equal((Object)this.message, (Object)other.message) && JodaBeanUtils.equal(this.attributes, other.attributes) && JodaBeanUtils.equal((Object)this.stackTrace, (Object)other.stackTrace) && JodaBeanUtils.equal(this.causeType, other.causeType);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.reason);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.message);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stackTrace);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.causeType);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FailureItem> {
        private FailureReason reason;
        private String message;
        private Map<String, String> attributes = ImmutableMap.of();
        private String stackTrace;
        private Class<? extends Throwable> causeType;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    return this.reason;
                }
                case 954925063: {
                    return this.message;
                }
                case 405645655: {
                    return this.attributes;
                }
                case 2026279837: {
                    return this.stackTrace;
                }
                case -1443456189: {
                    return this.causeType;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    this.reason = (FailureReason)newValue;
                    break;
                }
                case 954925063: {
                    this.message = (String)newValue;
                    break;
                }
                case 405645655: {
                    this.attributes = (Map)newValue;
                    break;
                }
                case 2026279837: {
                    this.stackTrace = (String)newValue;
                    break;
                }
                case -1443456189: {
                    this.causeType = (Class)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FailureItem build() {
            return new FailureItem(this.reason, this.message, this.attributes, this.stackTrace, this.causeType);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("FailureItem.Builder{");
            buf.append("reason").append('=').append(JodaBeanUtils.toString((Object)this.reason)).append(',').append(' ');
            buf.append("message").append('=').append(JodaBeanUtils.toString((Object)this.message)).append(',').append(' ');
            buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes)).append(',').append(' ');
            buf.append("stackTrace").append('=').append(JodaBeanUtils.toString((Object)this.stackTrace)).append(',').append(' ');
            buf.append("causeType").append('=').append(JodaBeanUtils.toString(this.causeType));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FailureReason> reason = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"reason", FailureItem.class, FailureReason.class);
        private final MetaProperty<String> message = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"message", FailureItem.class, String.class);
        private final MetaProperty<ImmutableMap<String, String>> attributes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"attributes", FailureItem.class, ImmutableMap.class);
        private final MetaProperty<String> stackTrace = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stackTrace", FailureItem.class, String.class);
        private final MetaProperty<Class<? extends Throwable>> causeType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"causeType", FailureItem.class, Class.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"reason", "message", "attributes", "stackTrace", "causeType"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    return this.reason;
                }
                case 954925063: {
                    return this.message;
                }
                case 405645655: {
                    return this.attributes;
                }
                case 2026279837: {
                    return this.stackTrace;
                }
                case -1443456189: {
                    return this.causeType;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FailureItem> builder() {
            return new Builder();
        }

        public Class<? extends FailureItem> beanType() {
            return FailureItem.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FailureReason> reason() {
            return this.reason;
        }

        public MetaProperty<String> message() {
            return this.message;
        }

        public MetaProperty<ImmutableMap<String, String>> attributes() {
            return this.attributes;
        }

        public MetaProperty<String> stackTrace() {
            return this.stackTrace;
        }

        public MetaProperty<Class<? extends Throwable>> causeType() {
            return this.causeType;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -934964668: {
                    return ((FailureItem)bean).getReason();
                }
                case 954925063: {
                    return ((FailureItem)bean).getMessage();
                }
                case 405645655: {
                    return ((FailureItem)bean).getAttributes();
                }
                case 2026279837: {
                    return ((FailureItem)bean).getStackTrace();
                }
                case -1443456189: {
                    return ((FailureItem)bean).causeType;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

