/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.ObservableId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", constructorScope="package")
final class CombinedMarketData
implements MarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketData underlying1;
    @PropertyDefinition(validate="notNull")
    private final MarketData underlying2;
    private static final TypedMetaBean<CombinedMarketData> META_BEAN = LightMetaBean.of(CombinedMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"underlying1", "underlying2"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        if (!this.underlying1.getValuationDate().equals(this.underlying2.getValuationDate())) {
            throw new IllegalArgumentException("Unable to combine market data instances with different valuation dates");
        }
    }

    @Override
    public LocalDate getValuationDate() {
        return this.underlying1.getValuationDate();
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        return this.underlying1.containsValue(id) || this.underlying2.containsValue(id);
    }

    @Override
    public <T> T getValue(MarketDataId<T> id) {
        Optional<Object> value1 = this.underlying1.findValue(id);
        return (T)value1.orElseGet(() -> this.underlying2.getValue(id));
    }

    @Override
    public <T> Optional<T> findValue(MarketDataId<T> id) {
        Optional<T> value1 = this.underlying1.findValue(id);
        return value1.isPresent() ? value1 : this.underlying2.findValue(id);
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return ImmutableSet.builder().addAll(this.underlying1.getIds()).addAll(this.underlying2.getIds()).build();
    }

    @Override
    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return ImmutableSet.builder().addAll(this.underlying1.findIds(name)).addAll(this.underlying2.findIds(name)).build();
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return ImmutableSet.builder().addAll(this.underlying1.getTimeSeriesIds()).addAll(this.underlying2.getTimeSeriesIds()).build();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        LocalDateDoubleTimeSeries timeSeries = this.underlying1.getTimeSeries(id);
        return !timeSeries.isEmpty() ? timeSeries : this.underlying2.getTimeSeries(id);
    }

    public static TypedMetaBean<CombinedMarketData> meta() {
        return META_BEAN;
    }

    CombinedMarketData(MarketData underlying1, MarketData underlying2) {
        JodaBeanUtils.notNull((Object)underlying1, (String)"underlying1");
        JodaBeanUtils.notNull((Object)underlying2, (String)"underlying2");
        this.underlying1 = underlying1;
        this.underlying2 = underlying2;
        this.validate();
    }

    public TypedMetaBean<CombinedMarketData> metaBean() {
        return META_BEAN;
    }

    public MarketData getUnderlying1() {
        return this.underlying1;
    }

    public MarketData getUnderlying2() {
        return this.underlying2;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CombinedMarketData other = (CombinedMarketData)obj;
            return JodaBeanUtils.equal((Object)this.underlying1, (Object)other.underlying1) && JodaBeanUtils.equal((Object)this.underlying2, (Object)other.underlying2);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying1);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying2);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CombinedMarketData{");
        buf.append("underlying1").append('=').append(JodaBeanUtils.toString((Object)this.underlying1)).append(',').append(' ');
        buf.append("underlying2").append('=').append(JodaBeanUtils.toString((Object)this.underlying2));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

