/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.NamedMarketDataId;
import com.opengamma.strata.data.ObservableId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class ExtendedMarketData<T>
implements MarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketDataId<T> id;
    @PropertyDefinition(validate="notNull")
    private final T value;
    @PropertyDefinition(validate="notNull")
    private final MarketData underlying;
    private static final MetaBean META_BEAN = LightMetaBean.of(ExtendedMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"id", "value", "underlying"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static <T> ExtendedMarketData<T> of(MarketDataId<T> id, T value, MarketData underlying) {
        return new ExtendedMarketData<T>(id, value, underlying);
    }

    @Override
    public LocalDate getValuationDate() {
        return this.underlying.getValuationDate();
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        if (this.id.equals(id)) {
            return true;
        }
        return this.underlying.containsValue(id);
    }

    public <R> R getValue(MarketDataId<R> id) {
        if (this.id.equals(id)) {
            return (R)this.value;
        }
        return this.underlying.getValue(id);
    }

    public <R> Optional<R> findValue(MarketDataId<R> id) {
        if (this.id.equals(id)) {
            return Optional.of(this.value);
        }
        return this.underlying.findValue(id);
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return ImmutableSet.builder().addAll(this.underlying.getIds()).add(this.id).build();
    }

    public <R> Set<MarketDataId<R>> findIds(MarketDataName<R> name) {
        NamedMarketDataId named;
        Set<MarketDataId<R>> ids = this.underlying.findIds(name);
        if (this.id instanceof NamedMarketDataId && (named = (NamedMarketDataId)this.id).getMarketDataName().equals(name)) {
            return ImmutableSet.builder().addAll(ids).add(this.id).build();
        }
        return ids;
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return this.underlying.getTimeSeriesIds();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        return this.underlying.getTimeSeries(id);
    }

    public static MetaBean meta() {
        return META_BEAN;
    }

    private ExtendedMarketData(MarketDataId<T> id, T value, MarketData underlying) {
        JodaBeanUtils.notNull(id, (String)"id");
        JodaBeanUtils.notNull(value, (String)"value");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.id = id;
        this.value = value;
        this.underlying = underlying;
    }

    public TypedMetaBean<ExtendedMarketData<T>> metaBean() {
        return (TypedMetaBean)META_BEAN;
    }

    public MarketDataId<T> getId() {
        return this.id;
    }

    public T getValue() {
        return this.value;
    }

    public MarketData getUnderlying() {
        return this.underlying;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ExtendedMarketData other = (ExtendedMarketData)obj;
            return JodaBeanUtils.equal(this.id, other.id) && JodaBeanUtils.equal(this.value, other.value) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ExtendedMarketData{");
        buf.append("id").append('=').append(JodaBeanUtils.toString(this.id)).append(',').append(' ');
        buf.append("value").append('=').append(JodaBeanUtils.toString(this.value)).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)META_BEAN);
    }
}

