/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableSource;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", cacheHashCode=true)
public final class FxRateId
implements MarketDataId<FxRate>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair pair;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource observableSource;
    private static final TypedMetaBean<FxRateId> META_BEAN = LightMetaBean.of(FxRateId.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"pair", "observableSource"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;
    private transient int cacheHashCode;

    public static FxRateId of(CurrencyPair currencyPair) {
        return new FxRateId(currencyPair, ObservableSource.NONE);
    }

    public static FxRateId of(Currency base, Currency counter) {
        return new FxRateId(CurrencyPair.of((Currency)base, (Currency)counter), ObservableSource.NONE);
    }

    public static FxRateId of(CurrencyPair currencyPair, ObservableSource observableSource) {
        return new FxRateId(currencyPair, observableSource);
    }

    public static FxRateId of(Currency base, Currency counter, ObservableSource observableSource) {
        return new FxRateId(CurrencyPair.of((Currency)base, (Currency)counter), observableSource);
    }

    @ImmutableConstructor
    private FxRateId(CurrencyPair currencyPair, ObservableSource observableSource) {
        ArgChecker.notNull((Object)currencyPair, (String)"currencyPair");
        ArgChecker.notNull((Object)((Object)observableSource), (String)"observableSource");
        this.pair = currencyPair.toConventional();
        this.observableSource = observableSource;
    }

    @Override
    public Class<FxRate> getMarketDataType() {
        return FxRate.class;
    }

    public String toString() {
        return new StringBuilder(32).append("FxRateId:").append(this.pair).append(this.observableSource.equals((Object)ObservableSource.NONE) ? "" : "/" + (Object)((Object)this.observableSource)).toString();
    }

    public static TypedMetaBean<FxRateId> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<FxRateId> metaBean() {
        return META_BEAN;
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    public ObservableSource getObservableSource() {
        return this.observableSource;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxRateId other = (FxRateId)obj;
            return JodaBeanUtils.equal((Object)this.pair, (Object)other.pair) && JodaBeanUtils.equal((Object)((Object)this.observableSource), (Object)((Object)other.observableSource));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.cacheHashCode;
        if (hash == 0) {
            hash = this.getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.pair);
            this.cacheHashCode = hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.observableSource));
        }
        return hash;
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

