/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.ImmutableMarketDataBuilder;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.NamedMarketDataId;
import com.opengamma.strata.data.ObservableId;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class ImmutableMarketData
implements MarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends MarketDataId<?>, ?>")
    private final ImmutableMap<MarketDataId<?>, Object> values;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<ObservableId, LocalDateDoubleTimeSeries> timeSeries;
    private static final long serialVersionUID = 1L;

    public static ImmutableMarketData of(LocalDate valuationDate, Map<? extends MarketDataId<?>, ?> values) {
        MapStream.of(values).forEach((id, value) -> ImmutableMarketData.checkType(id, value));
        return new ImmutableMarketData(valuationDate, values, (Map<ObservableId, LocalDateDoubleTimeSeries>)ImmutableMap.of());
    }

    static void checkType(MarketDataId<?> id, Object value) {
        if (!id.getMarketDataType().isInstance(value)) {
            if (value == null) {
                throw new IllegalArgumentException(Messages.format((String)"Value for identifier '{}' must not be null", id));
            }
            throw new ClassCastException(Messages.format((String)"Value for identifier '{}' does not implement expected type '{}': '{}'", (Object[])new Object[]{id, id.getMarketDataType().getSimpleName(), value}));
        }
    }

    public static ImmutableMarketDataBuilder builder(LocalDate valuationDate) {
        return new ImmutableMarketDataBuilder(valuationDate);
    }

    public ImmutableMarketDataBuilder toBuilder() {
        return new ImmutableMarketDataBuilder(this.valuationDate, (Map<MarketDataId<?>, Object>)this.values, (Map<ObservableId, LocalDateDoubleTimeSeries>)this.timeSeries);
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        return this.values.containsKey(id);
    }

    public ImmutableMarketData combinedWith(ImmutableMarketData other) {
        HashMap combinedValues = new HashMap((Map<MarketDataId<?>, Object>)other.values);
        combinedValues.putAll((Map<MarketDataId<?>, Object>)this.values);
        HashMap<ObservableId, LocalDateDoubleTimeSeries> combinedTimeSeries = new HashMap<ObservableId, LocalDateDoubleTimeSeries>((Map<ObservableId, LocalDateDoubleTimeSeries>)other.timeSeries);
        combinedTimeSeries.putAll((Map<ObservableId, LocalDateDoubleTimeSeries>)this.timeSeries);
        if (!this.valuationDate.equals(other.valuationDate)) {
            throw new IllegalArgumentException("Unable to combine market data instances with different valuation dates");
        }
        return new ImmutableMarketData(this.valuationDate, combinedValues, combinedTimeSeries);
    }

    @Override
    public MarketData combinedWith(MarketData other) {
        if (!(other instanceof ImmutableMarketData)) {
            return MarketData.super.combinedWith(other);
        }
        return this.combinedWith((ImmutableMarketData)other);
    }

    @Override
    public <T> T getValue(MarketDataId<T> id) {
        Object value = this.values.get(id);
        if (value == null) {
            throw new MarketDataNotFoundException(this.msgValueNotFound(id));
        }
        return (T)value;
    }

    private String msgValueNotFound(MarketDataId<?> id) {
        return Messages.format((String)"Market data not found for identifier '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()});
    }

    @Override
    public <T> Optional<T> findValue(MarketDataId<T> id) {
        Object value = this.values.get(id);
        return Optional.ofNullable(value);
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return this.values.keySet();
    }

    @Override
    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return (Set)this.values.keySet().stream().filter(id -> id instanceof NamedMarketDataId).filter(id -> ((NamedMarketDataId)id).getMarketDataName().equals(name)).map(id -> id).collect(Guavate.toImmutableSet());
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return this.timeSeries.keySet();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        LocalDateDoubleTimeSeries found = (LocalDateDoubleTimeSeries)this.timeSeries.get((Object)id);
        return found == null ? LocalDateDoubleTimeSeries.empty() : found;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    ImmutableMarketData(LocalDate valuationDate, Map<? extends MarketDataId<?>, ?> values, Map<ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        JodaBeanUtils.notNull((Object)valuationDate, (String)"valuationDate");
        JodaBeanUtils.notNull(values, (String)"values");
        JodaBeanUtils.notNull(timeSeries, (String)"timeSeries");
        this.valuationDate = valuationDate;
        this.values = ImmutableMap.copyOf(values);
        this.timeSeries = ImmutableMap.copyOf(timeSeries);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public ImmutableMap<MarketDataId<?>, Object> getValues() {
        return this.values;
    }

    public ImmutableMap<ObservableId, LocalDateDoubleTimeSeries> getTimeSeries() {
        return this.timeSeries;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableMarketData other = (ImmutableMarketData)obj;
            return JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal(this.values, other.values) && JodaBeanUtils.equal(this.timeSeries, other.timeSeries);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.values);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.timeSeries);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ImmutableMarketData{");
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("values").append('=').append(JodaBeanUtils.toString(this.values)).append(',').append(' ');
        buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableMarketData> {
        private LocalDate valuationDate;
        private Map<? extends MarketDataId<?>, ?> values = ImmutableMap.of();
        private Map<ObservableId, LocalDateDoubleTimeSeries> timeSeries = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -823812830: {
                    return this.values;
                }
                case 779431844: {
                    return this.timeSeries;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case -823812830: {
                    this.values = (Map)newValue;
                    break;
                }
                case 779431844: {
                    this.timeSeries = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableMarketData build() {
            return new ImmutableMarketData(this.valuationDate, this.values, this.timeSeries);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ImmutableMarketData.Builder{");
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("values").append('=').append(JodaBeanUtils.toString(this.values)).append(',').append(' ');
            buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", ImmutableMarketData.class, LocalDate.class);
        private final MetaProperty<ImmutableMap<MarketDataId<?>, Object>> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", ImmutableMarketData.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<ObservableId, LocalDateDoubleTimeSeries>> timeSeries = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeSeries", ImmutableMarketData.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"valuationDate", "values", "timeSeries"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return this.valuationDate;
                }
                case -823812830: {
                    return this.values;
                }
                case 779431844: {
                    return this.timeSeries;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableMarketData> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableMarketData> beanType() {
            return ImmutableMarketData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<ImmutableMap<MarketDataId<?>, Object>> values() {
            return this.values;
        }

        public MetaProperty<ImmutableMap<ObservableId, LocalDateDoubleTimeSeries>> timeSeries() {
            return this.timeSeries;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 113107279: {
                    return ((ImmutableMarketData)bean).getValuationDate();
                }
                case -823812830: {
                    return ((ImmutableMarketData)bean).getValues();
                }
                case 779431844: {
                    return ((ImmutableMarketData)bean).getTimeSeries();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

