/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.ImmutableMarketData;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class ImmutableMarketDataBuilder {
    private LocalDate valuationDate;
    private final Map<MarketDataId<?>, Object> values = new HashMap();
    private final Map<ObservableId, LocalDateDoubleTimeSeries> timeSeries = new HashMap<ObservableId, LocalDateDoubleTimeSeries>();

    ImmutableMarketDataBuilder(LocalDate valuationDate) {
        this.valuationDate = (LocalDate)ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
    }

    ImmutableMarketDataBuilder(LocalDate valuationDate, Map<MarketDataId<?>, Object> values, Map<ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        this.valuationDate = (LocalDate)ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        this.values.putAll((Map)ArgChecker.notNull(values, (String)"values"));
        this.timeSeries.putAll((Map)ArgChecker.notNull(timeSeries, (String)"timeSeries"));
    }

    public ImmutableMarketDataBuilder valuationDate(LocalDate valuationDate) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        this.valuationDate = valuationDate;
        return this;
    }

    public ImmutableMarketDataBuilder values(Map<? extends MarketDataId<?>, ?> values) {
        this.values.clear();
        return this.addValueMap(values);
    }

    public ImmutableMarketDataBuilder timeSeries(Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        this.timeSeries.clear();
        return this.addTimeSeriesMap(timeSeries);
    }

    public <T> ImmutableMarketDataBuilder addValue(MarketDataId<T> id, T value) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(value, (String)"value");
        this.values.put(id, value);
        return this;
    }

    public <T> ImmutableMarketDataBuilder addValueUnsafe(MarketDataId<?> id, Object value) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull((Object)value, (String)"value");
        ImmutableMarketData.checkType(id, value);
        this.values.put(id, value);
        return this;
    }

    public ImmutableMarketDataBuilder addValueMap(Map<? extends MarketDataId<?>, ?> values) {
        ArgChecker.notNull(values, (String)"values");
        values.entrySet().forEach(e -> this.addValueUnsafe((MarketDataId)e.getKey(), e.getValue()));
        return this;
    }

    public ImmutableMarketDataBuilder addTimeSeries(ObservableId id, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)id, (String)"id");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.timeSeries.put(id, timeSeries);
        return this;
    }

    public ImmutableMarketDataBuilder addTimeSeriesMap(Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeriesMap) {
        ArgChecker.notNull(timeSeriesMap, (String)"timeSeriesMap");
        this.timeSeries.putAll(timeSeriesMap);
        return this;
    }

    public ImmutableMarketDataBuilder add(MarketData other) {
        ArgChecker.notNull((Object)other, (String)"other");
        if (other instanceof ImmutableMarketData) {
            ImmutableMarketData otherMd = (ImmutableMarketData)other;
            this.addTimeSeriesMap((Map<? extends ObservableId, LocalDateDoubleTimeSeries>)otherMd.getTimeSeries());
            this.addValueMap((Map<? extends MarketDataId<?>, ?>)otherMd.getValues());
        } else {
            other.getTimeSeriesIds().forEach(id -> this.addTimeSeries((ObservableId)id, other.getTimeSeries((ObservableId)id)));
            other.getIds().forEach(id -> this.addValueUnsafe((MarketDataId<?>)id, other.getValue(id)));
        }
        return this;
    }

    public ImmutableMarketDataBuilder removeTimeSeriesIf(Predicate<ObservableId> predicate) {
        ArgChecker.notNull(predicate, (String)"predicate");
        this.timeSeries.keySet().removeIf(predicate);
        return this;
    }

    public ImmutableMarketDataBuilder removeValueIf(Predicate<MarketDataId<?>> predicate) {
        ArgChecker.notNull(predicate, (String)"predicate");
        this.values.keySet().removeIf(predicate);
        return this;
    }

    public ImmutableMarketData build() {
        return new ImmutableMarketData(this.valuationDate, this.values, this.timeSeries);
    }
}

