/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.CombinedMarketData;
import com.opengamma.strata.data.ExtendedMarketData;
import com.opengamma.strata.data.ImmutableMarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.ObservableId;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface MarketData {
    public static MarketData of(LocalDate valuationDate, Map<? extends MarketDataId<?>, ?> values) {
        return ImmutableMarketData.of(valuationDate, values);
    }

    public static MarketData of(LocalDate valuationDate, Map<? extends MarketDataId<?>, ?> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        return ImmutableMarketData.builder(valuationDate).values(values).timeSeries(timeSeries).build();
    }

    public static MarketData empty(LocalDate valuationDate) {
        return ImmutableMarketData.builder(valuationDate).build();
    }

    public LocalDate getValuationDate();

    default public boolean containsValue(MarketDataId<?> id) {
        return this.findValue(id).isPresent();
    }

    default public <T> T getValue(MarketDataId<T> id) {
        return this.findValue(id).orElseThrow(() -> new MarketDataNotFoundException(Messages.format((String)"Market data not found for '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()})));
    }

    public <T> Optional<T> findValue(MarketDataId<T> var1);

    public Set<MarketDataId<?>> getIds();

    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> var1);

    public Set<ObservableId> getTimeSeriesIds();

    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId var1);

    default public MarketData combinedWith(MarketData other) {
        return new CombinedMarketData(this, other);
    }

    default public <T> MarketData withValue(MarketDataId<T> id, T value) {
        return ExtendedMarketData.of(id, value, this);
    }
}

