/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.FxRateId;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.ObservableSource;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class MarketDataFxRateProvider
implements FxRateProvider,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MarketData marketData;
    @PropertyDefinition(validate="notNull")
    private final ObservableSource fxRatesSource;
    @PropertyDefinition(get="optional")
    private final Currency triangulationCurrency;
    private static final TypedMetaBean<MarketDataFxRateProvider> META_BEAN = LightMetaBean.of(MarketDataFxRateProvider.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"marketData", "fxRatesSource", "triangulationCurrency"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static MarketDataFxRateProvider of(MarketData marketData) {
        return MarketDataFxRateProvider.of(marketData, ObservableSource.NONE);
    }

    public static MarketDataFxRateProvider of(MarketData marketData, ObservableSource fxRatesSource) {
        return new MarketDataFxRateProvider(marketData, fxRatesSource, null);
    }

    public static MarketDataFxRateProvider of(MarketData marketData, ObservableSource fxRatesSource, Currency triangulationCurrency) {
        ArgChecker.notNull((Object)triangulationCurrency, (String)"triangulationCurrency");
        return new MarketDataFxRateProvider(marketData, fxRatesSource, triangulationCurrency);
    }

    public double fxRate(Currency baseCurrency, Currency counterCurrency) {
        Optional<FxRate> rateTriangular2;
        if (baseCurrency.equals((Object)counterCurrency)) {
            return 1.0;
        }
        Optional<FxRate> rate = this.marketData.findValue(FxRateId.of(baseCurrency, counterCurrency, this.fxRatesSource));
        if (rate.isPresent()) {
            return rate.get().fxRate(baseCurrency, counterCurrency);
        }
        if (this.triangulationCurrency != null) {
            Optional<FxRate> rateBase1 = this.marketData.findValue(FxRateId.of(baseCurrency, this.triangulationCurrency, this.fxRatesSource));
            Optional<FxRate> rateBase2 = this.marketData.findValue(FxRateId.of(this.triangulationCurrency, counterCurrency, this.fxRatesSource));
            if (rateBase1.isPresent() && rateBase2.isPresent()) {
                return rateBase1.get().crossRate(rateBase2.get()).fxRate(baseCurrency, counterCurrency);
            }
        }
        Currency triangularBaseCcy = baseCurrency.getTriangulationCurrency();
        Optional<FxRate> rateBase1 = this.marketData.findValue(FxRateId.of(baseCurrency, triangularBaseCcy, this.fxRatesSource));
        Optional<FxRate> rateBase2 = this.marketData.findValue(FxRateId.of(triangularBaseCcy, counterCurrency, this.fxRatesSource));
        if (rateBase1.isPresent() && rateBase2.isPresent()) {
            return rateBase1.get().crossRate(rateBase2.get()).fxRate(baseCurrency, counterCurrency);
        }
        Currency triangularCounterCcy = counterCurrency.getTriangulationCurrency();
        Optional<FxRate> rateCounter1 = this.marketData.findValue(FxRateId.of(baseCurrency, triangularCounterCcy, this.fxRatesSource));
        Optional<FxRate> rateCounter2 = this.marketData.findValue(FxRateId.of(triangularCounterCcy, counterCurrency, this.fxRatesSource));
        if (rateCounter1.isPresent() && rateCounter2.isPresent()) {
            return rateCounter1.get().crossRate(rateCounter2.get()).fxRate(baseCurrency, counterCurrency);
        }
        if (rateBase1.isPresent() && rateCounter2.isPresent() && (rateTriangular2 = this.marketData.findValue(FxRateId.of(triangularBaseCcy, triangularCounterCcy, this.fxRatesSource))).isPresent()) {
            return rateBase1.get().crossRate(rateTriangular2.get()).crossRate(rateCounter2.get()).fxRate(baseCurrency, counterCurrency);
        }
        if (this.fxRatesSource.equals((Object)ObservableSource.NONE)) {
            throw new MarketDataNotFoundException(Messages.format((String)"No FX rate market data for {}/{}", (Object[])new Object[]{baseCurrency, counterCurrency}));
        }
        throw new MarketDataNotFoundException(Messages.format((String)"No FX rate market data for {}/{} using source '{}'", (Object[])new Object[]{baseCurrency, counterCurrency, this.fxRatesSource}));
    }

    public static TypedMetaBean<MarketDataFxRateProvider> meta() {
        return META_BEAN;
    }

    private MarketDataFxRateProvider(MarketData marketData, ObservableSource fxRatesSource, Currency triangulationCurrency) {
        JodaBeanUtils.notNull((Object)marketData, (String)"marketData");
        JodaBeanUtils.notNull((Object)((Object)fxRatesSource), (String)"fxRatesSource");
        this.marketData = marketData;
        this.fxRatesSource = fxRatesSource;
        this.triangulationCurrency = triangulationCurrency;
    }

    public TypedMetaBean<MarketDataFxRateProvider> metaBean() {
        return META_BEAN;
    }

    public MarketData getMarketData() {
        return this.marketData;
    }

    public ObservableSource getFxRatesSource() {
        return this.fxRatesSource;
    }

    public Optional<Currency> getTriangulationCurrency() {
        return Optional.ofNullable(this.triangulationCurrency);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MarketDataFxRateProvider other = (MarketDataFxRateProvider)obj;
            return JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData) && JodaBeanUtils.equal((Object)((Object)this.fxRatesSource), (Object)((Object)other.fxRatesSource)) && JodaBeanUtils.equal((Object)this.triangulationCurrency, (Object)other.triangulationCurrency);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.fxRatesSource));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.triangulationCurrency);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("MarketDataFxRateProvider{");
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData)).append(',').append(' ');
        buf.append("fxRatesSource").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fxRatesSource))).append(',').append(' ');
        buf.append("triangulationCurrency").append('=').append(JodaBeanUtils.toString((Object)this.triangulationCurrency));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

