/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light", constructorScope="package")
final class CombinedScenarioMarketData
implements ScenarioMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ScenarioMarketData underlying1;
    @PropertyDefinition(validate="notNull")
    private final ScenarioMarketData underlying2;
    @PropertyDefinition(overrideGet=true)
    private final int scenarioCount;
    private static final TypedMetaBean<CombinedScenarioMarketData> META_BEAN = LightMetaBean.of(CombinedScenarioMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"underlying1", "underlying2", "scenarioCount"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    CombinedScenarioMarketData(ScenarioMarketData underlying1, ScenarioMarketData underlying2) {
        this.underlying1 = underlying1;
        this.underlying2 = underlying2;
        if (underlying1.getScenarioCount() == 1) {
            this.scenarioCount = underlying2.getScenarioCount();
        } else if (underlying2.getScenarioCount() == 1) {
            this.scenarioCount = underlying1.getScenarioCount();
        } else if (underlying1.getScenarioCount() == underlying2.getScenarioCount()) {
            this.scenarioCount = underlying1.getScenarioCount();
        } else {
            throw new IllegalArgumentException(Messages.format((String)"When combining scenario market data, both sets of data must have the same number of scenarios or one of them must have one scenario. Found {} and {} scenarios", (Object[])new Object[]{underlying1.getScenarioCount(), underlying2.getScenarioCount()}));
        }
    }

    @Override
    public MarketDataBox<LocalDate> getValuationDate() {
        return this.underlying1.getValuationDate();
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        return this.underlying1.containsValue(id) || this.underlying2.containsValue(id);
    }

    @Override
    public <T> MarketDataBox<T> getValue(MarketDataId<T> id) {
        Optional<MarketDataBox<MarketDataBox>> value1 = this.underlying1.findValue(id);
        return value1.orElseGet(() -> this.underlying2.getValue(id));
    }

    @Override
    public <T> Optional<MarketDataBox<T>> findValue(MarketDataId<T> id) {
        Optional<MarketDataBox<MarketDataBox<T>>> value1 = this.underlying1.findValue(id);
        return value1.isPresent() ? value1 : this.underlying2.findValue(id);
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return ImmutableSet.builder().addAll(this.underlying1.getIds()).addAll(this.underlying2.getIds()).build();
    }

    @Override
    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return ImmutableSet.builder().addAll(this.underlying1.findIds(name)).addAll(this.underlying2.findIds(name)).build();
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return ImmutableSet.builder().addAll(this.underlying1.getTimeSeriesIds()).addAll(this.underlying2.getTimeSeriesIds()).build();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        LocalDateDoubleTimeSeries timeSeries = this.underlying1.getTimeSeries(id);
        return !timeSeries.isEmpty() ? timeSeries : this.underlying2.getTimeSeries(id);
    }

    public static TypedMetaBean<CombinedScenarioMarketData> meta() {
        return META_BEAN;
    }

    CombinedScenarioMarketData(ScenarioMarketData underlying1, ScenarioMarketData underlying2, int scenarioCount) {
        JodaBeanUtils.notNull((Object)underlying1, (String)"underlying1");
        JodaBeanUtils.notNull((Object)underlying2, (String)"underlying2");
        this.underlying1 = underlying1;
        this.underlying2 = underlying2;
        this.scenarioCount = scenarioCount;
    }

    public TypedMetaBean<CombinedScenarioMarketData> metaBean() {
        return META_BEAN;
    }

    public ScenarioMarketData getUnderlying1() {
        return this.underlying1;
    }

    public ScenarioMarketData getUnderlying2() {
        return this.underlying2;
    }

    @Override
    public int getScenarioCount() {
        return this.scenarioCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CombinedScenarioMarketData other = (CombinedScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.underlying1, (Object)other.underlying1) && JodaBeanUtils.equal((Object)this.underlying2, (Object)other.underlying2) && this.scenarioCount == other.scenarioCount;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying1);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying2);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.scenarioCount);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("CombinedScenarioMarketData{");
        buf.append("underlying1").append('=').append(JodaBeanUtils.toString((Object)this.underlying1)).append(',').append(' ');
        buf.append("underlying2").append('=').append(JodaBeanUtils.toString((Object)this.underlying2)).append(',').append(' ');
        buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

