/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyAmountArray;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioFxConvertible;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CurrencyScenarioArray
implements ScenarioArray<CurrencyAmount>,
ScenarioFxConvertible<CurrencyScenarioArray>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmountArray amounts;
    private static final long serialVersionUID = 1L;

    public static CurrencyScenarioArray of(CurrencyAmountArray amounts) {
        return new CurrencyScenarioArray(amounts);
    }

    public static CurrencyScenarioArray of(Currency currency, DoubleArray values) {
        return new CurrencyScenarioArray(CurrencyAmountArray.of((Currency)currency, (DoubleArray)values));
    }

    public static CurrencyScenarioArray of(List<CurrencyAmount> amounts) {
        return new CurrencyScenarioArray(CurrencyAmountArray.of(amounts));
    }

    public static CurrencyScenarioArray of(int size, IntFunction<CurrencyAmount> amountFunction) {
        return new CurrencyScenarioArray(CurrencyAmountArray.of((int)size, amountFunction));
    }

    public Currency getCurrency() {
        return this.amounts.getCurrency();
    }

    @Override
    public int getScenarioCount() {
        return this.amounts.size();
    }

    @Override
    public CurrencyAmount get(int index) {
        return this.amounts.get(index);
    }

    @Override
    public Stream<CurrencyAmount> stream() {
        return this.amounts.stream();
    }

    @Override
    public CurrencyScenarioArray convertedTo(Currency reportingCurrency, ScenarioFxRateProvider fxRateProvider) {
        if (this.getCurrency().equals((Object)reportingCurrency)) {
            return this;
        }
        if (fxRateProvider.getScenarioCount() != this.amounts.size()) {
            throw new IllegalArgumentException(Messages.format((String)"Expected {} FX rates but received {}", (Object[])new Object[]{this.amounts.size(), fxRateProvider.getScenarioCount()}));
        }
        DoubleArray convertedValues = this.amounts.getValues().mapWithIndex((i, v) -> v * fxRateProvider.fxRate(this.getCurrency(), reportingCurrency, i));
        return CurrencyScenarioArray.of(reportingCurrency, convertedValues);
    }

    public CurrencyScenarioArray plus(CurrencyScenarioArray other) {
        return CurrencyScenarioArray.of(this.amounts.plus(other.amounts));
    }

    public CurrencyScenarioArray plus(CurrencyAmount amount) {
        return CurrencyScenarioArray.of(this.amounts.plus(amount));
    }

    public CurrencyScenarioArray minus(CurrencyScenarioArray other) {
        return CurrencyScenarioArray.of(this.amounts.minus(other.amounts));
    }

    public CurrencyScenarioArray minus(CurrencyAmount amount) {
        return CurrencyScenarioArray.of(this.amounts.minus(amount));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CurrencyScenarioArray(CurrencyAmountArray amounts) {
        JodaBeanUtils.notNull((Object)amounts, (String)"amounts");
        this.amounts = amounts;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyAmountArray getAmounts() {
        return this.amounts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CurrencyScenarioArray other = (CurrencyScenarioArray)obj;
            return JodaBeanUtils.equal((Object)this.amounts, (Object)other.amounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.amounts);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("CurrencyScenarioArray{");
        buf.append("amounts").append('=').append(JodaBeanUtils.toString((Object)this.amounts));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CurrencyScenarioArray> {
        private CurrencyAmountArray amounts;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    this.amounts = (CurrencyAmountArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CurrencyScenarioArray build() {
            return new CurrencyScenarioArray(this.amounts);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("CurrencyScenarioArray.Builder{");
            buf.append("amounts").append('=').append(JodaBeanUtils.toString((Object)this.amounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyAmountArray> amounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amounts", CurrencyScenarioArray.class, CurrencyAmountArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"amounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CurrencyScenarioArray> builder() {
            return new Builder();
        }

        public Class<? extends CurrencyScenarioArray> beanType() {
            return CurrencyScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyAmountArray> amounts() {
            return this.amounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return ((CurrencyScenarioArray)bean).getAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

