/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioFxConvertible;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
final class DefaultScenarioArray<T>
implements ScenarioArray<T>,
ScenarioFxConvertible<ScenarioArray<?>>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableList<T> values;
    private static final long serialVersionUID = 1L;

    @SafeVarargs
    public static <T> DefaultScenarioArray<T> of(T ... values) {
        return new DefaultScenarioArray<T>(ImmutableList.copyOf((Object[])values));
    }

    public static <T> DefaultScenarioArray<T> of(List<T> values) {
        return new DefaultScenarioArray<T>(values);
    }

    public static <T> DefaultScenarioArray<T> of(int scenarioCount, IntFunction<T> valueFunction) {
        ArgChecker.notNegativeOrZero((int)scenarioCount, (String)"scenarioCount");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < scenarioCount; ++i) {
            builder.add(valueFunction.apply(i));
        }
        return new DefaultScenarioArray<T>(builder.build());
    }

    @Override
    public int getScenarioCount() {
        return this.values.size();
    }

    @Override
    public T get(int index) {
        return (T)this.values.get(index);
    }

    @Override
    public Stream<T> stream() {
        return this.values.stream();
    }

    @Override
    public ScenarioArray<?> convertedTo(Currency resultCurrency, ScenarioFxRateProvider fxRateProvider) {
        int scenarioCount = this.getScenarioCount();
        if (fxRateProvider.getScenarioCount() != scenarioCount) {
            throw new IllegalArgumentException(Messages.format((String)"Expected {} FX rates but received {}", (Object[])new Object[]{scenarioCount, fxRateProvider.getScenarioCount()}));
        }
        ImmutableList converted = (ImmutableList)Guavate.zipWithIndex((Stream)this.values.stream()).map(tp -> this.convert(resultCurrency, fxRateProvider, tp.getFirst(), tp.getSecond())).collect(Guavate.toImmutableList());
        return DefaultScenarioArray.of(converted);
    }

    private Object convert(Currency reportingCurrency, ScenarioFxRateProvider fxRateProvider, Object base, int index) {
        if (base instanceof FxConvertible) {
            FxConvertible convertible = (FxConvertible)base;
            return convertible.convertedTo(reportingCurrency, fxRateProvider.fxRateProvider(index));
        }
        return base;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaDefaultScenarioArray(Class<R> cls) {
        return Meta.INSTANCE;
    }

    private DefaultScenarioArray(List<T> values) {
        JodaBeanUtils.notNull(values, (String)"values");
        this.values = ImmutableList.copyOf(values);
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<T> getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultScenarioArray other = (DefaultScenarioArray)obj;
            return JodaBeanUtils.equal(this.values, other.values);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.values);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultScenarioArray{");
        buf.append("values").append('=').append(JodaBeanUtils.toString(this.values));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<T>
    extends DirectPrivateBeanBuilder<DefaultScenarioArray<T>> {
        private List<T> values = ImmutableList.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return this.values;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    this.values = (List)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DefaultScenarioArray<T> build() {
            return new DefaultScenarioArray(this.values);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("DefaultScenarioArray.Builder{");
            buf.append("values").append('=').append(JodaBeanUtils.toString(this.values));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<T>> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", DefaultScenarioArray.class, ImmutableList.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"values"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return this.values;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DefaultScenarioArray<T>> builder() {
            return new Builder();
        }

        public Class<? extends DefaultScenarioArray<T>> beanType() {
            return DefaultScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<T>> values() {
            return this.values;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return ((DefaultScenarioArray)bean).getValues();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

