/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.IntToDoubleFunction;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class DoubleScenarioArray
implements ScenarioArray<Double>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final DoubleArray values;
    private static final long serialVersionUID = 1L;

    public static DoubleScenarioArray of(DoubleArray values) {
        return new DoubleScenarioArray(values);
    }

    public static DoubleScenarioArray of(List<Double> values) {
        return new DoubleScenarioArray(DoubleArray.copyOf(values));
    }

    public static DoubleScenarioArray of(int size, IntToDoubleFunction valueFunction) {
        ArgChecker.notNegativeOrZero((int)size, (String)"size");
        return new DoubleScenarioArray(DoubleArray.of((int)size, (IntToDoubleFunction)valueFunction));
    }

    @Override
    public int getScenarioCount() {
        return this.values.size();
    }

    @Override
    public Double get(int index) {
        return this.values.get(index);
    }

    @Override
    public Stream<Double> stream() {
        return this.values.stream().boxed();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private DoubleScenarioArray(DoubleArray values) {
        JodaBeanUtils.notNull((Object)values, (String)"values");
        this.values = values;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public DoubleArray getValues() {
        return this.values;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DoubleScenarioArray other = (DoubleScenarioArray)obj;
            return JodaBeanUtils.equal((Object)this.values, (Object)other.values);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.values);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DoubleScenarioArray{");
        buf.append("values").append('=').append(JodaBeanUtils.toString((Object)this.values));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DoubleScenarioArray> {
        private DoubleArray values;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return this.values;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    this.values = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DoubleScenarioArray build() {
            return new DoubleScenarioArray(this.values);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("DoubleScenarioArray.Builder{");
            buf.append("values").append('=').append(JodaBeanUtils.toString((Object)this.values));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<DoubleArray> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", DoubleScenarioArray.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"values"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return this.values;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DoubleScenarioArray> builder() {
            return new Builder();
        }

        public Class<? extends DoubleScenarioArray> beanType() {
            return DoubleScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<DoubleArray> values() {
            return this.values;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -823812830: {
                    return ((DoubleScenarioArray)bean).getValues();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

