/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxRateScenarioArray
implements ScenarioArray<FxRate>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyPair pair;
    @PropertyDefinition(validate="notNull", get="private")
    private final DoubleArray rates;
    private static final long serialVersionUID = 1L;

    public static FxRateScenarioArray of(CurrencyPair currencyPair, DoubleArray rates) {
        return new FxRateScenarioArray(currencyPair, rates);
    }

    public static FxRateScenarioArray of(Currency base, Currency counter, DoubleArray rates) {
        return new FxRateScenarioArray(CurrencyPair.of((Currency)base, (Currency)counter), rates);
    }

    @Override
    public int getScenarioCount() {
        return this.rates.size();
    }

    @Override
    public FxRate get(int scenarioIndex) {
        return FxRate.of((CurrencyPair)this.pair, (double)this.rates.get(scenarioIndex));
    }

    @Override
    public Stream<FxRate> stream() {
        return this.rates.stream().mapToObj(rate -> FxRate.of((CurrencyPair)this.pair, (double)rate));
    }

    public double fxRate(Currency baseCurrency, Currency counterCurrency, int scenarioIndex) {
        if (baseCurrency.equals((Object)this.pair.getBase()) && counterCurrency.equals((Object)this.pair.getCounter())) {
            return this.rates.get(scenarioIndex);
        }
        if (counterCurrency.equals((Object)this.pair.getBase()) && baseCurrency.equals((Object)this.pair.getCounter())) {
            return 1.0 / this.rates.get(scenarioIndex);
        }
        throw new IllegalArgumentException("Unknown rate: " + baseCurrency + "/" + counterCurrency);
    }

    public DoubleArray convert(DoubleArray amounts, Currency fromCurrency, Currency toCurrency) {
        if (fromCurrency.equals((Object)this.pair.getBase()) && toCurrency.equals((Object)this.pair.getCounter())) {
            return amounts.multipliedBy(this.rates);
        }
        if (toCurrency.equals((Object)this.pair.getBase()) && fromCurrency.equals((Object)this.pair.getCounter())) {
            return this.rates.mapWithIndex((i, v) -> amounts.get(i) / v);
        }
        throw new IllegalArgumentException("Unknown rate: " + fromCurrency + "/" + toCurrency);
    }

    public FxRateScenarioArray crossRates(FxRateScenarioArray other) {
        return this.pair.cross(other.pair).map(cross -> this.computeCross(other, (CurrencyPair)cross)).orElseThrow(() -> new IllegalArgumentException(Messages.format((String)"Unable to cross when no unique common currency: {} and {}", (Object[])new Object[]{this.pair, other.pair})));
    }

    private FxRateScenarioArray computeCross(FxRateScenarioArray other, CurrencyPair crossPairAC) {
        Currency currA = crossPairAC.getBase();
        Currency currC = crossPairAC.getCounter();
        boolean crossBaseCurrencyInFx1 = this.pair.contains(currA);
        FxRateScenarioArray fxABorBA = crossBaseCurrencyInFx1 ? this : other;
        FxRateScenarioArray fxBCorCB = crossBaseCurrencyInFx1 ? other : this;
        DoubleArray ratesAB = fxABorBA.getPair().getBase().equals((Object)currA) ? fxABorBA.rates : fxABorBA.rates.map(v -> 1.0 / v);
        DoubleArray ratesBC = fxBCorCB.getPair().getCounter().equals((Object)currC) ? fxBCorCB.rates : fxBCorCB.rates.map(v -> 1.0 / v);
        return FxRateScenarioArray.of(crossPairAC, ratesAB.multipliedBy(ratesBC));
    }

    @ImmutableValidator
    private void validate() {
        if (this.pair.getBase().equals((Object)this.pair.getCounter()) && !this.rates.stream().allMatch(v -> v == 1.0)) {
            throw new IllegalArgumentException("Conversion rate between identical currencies must be one");
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxRateScenarioArray(CurrencyPair pair, DoubleArray rates) {
        JodaBeanUtils.notNull((Object)pair, (String)"pair");
        JodaBeanUtils.notNull((Object)rates, (String)"rates");
        this.pair = pair;
        this.rates = rates;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyPair getPair() {
        return this.pair;
    }

    private DoubleArray getRates() {
        return this.rates;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxRateScenarioArray other = (FxRateScenarioArray)obj;
            return JodaBeanUtils.equal((Object)this.pair, (Object)other.pair) && JodaBeanUtils.equal((Object)this.rates, (Object)other.rates);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.pair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rates);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("FxRateScenarioArray{");
        buf.append("pair").append('=').append(JodaBeanUtils.toString((Object)this.pair)).append(',').append(' ');
        buf.append("rates").append('=').append(JodaBeanUtils.toString((Object)this.rates));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxRateScenarioArray> {
        private CurrencyPair pair;
        private DoubleArray rates;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    return this.pair;
                }
                case 108285843: {
                    return this.rates;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    this.pair = (CurrencyPair)newValue;
                    break;
                }
                case 108285843: {
                    this.rates = (DoubleArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxRateScenarioArray build() {
            return new FxRateScenarioArray(this.pair, this.rates);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FxRateScenarioArray.Builder{");
            buf.append("pair").append('=').append(JodaBeanUtils.toString((Object)this.pair)).append(',').append(' ');
            buf.append("rates").append('=').append(JodaBeanUtils.toString((Object)this.rates));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> pair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"pair", FxRateScenarioArray.class, CurrencyPair.class);
        private final MetaProperty<DoubleArray> rates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rates", FxRateScenarioArray.class, DoubleArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"pair", "rates"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    return this.pair;
                }
                case 108285843: {
                    return this.rates;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxRateScenarioArray> builder() {
            return new Builder();
        }

        public Class<? extends FxRateScenarioArray> beanType() {
            return FxRateScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> pair() {
            return this.pair;
        }

        public MetaProperty<DoubleArray> rates() {
            return this.rates;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3433178: {
                    return ((FxRateScenarioArray)bean).getPair();
                }
                case 108285843: {
                    return ((FxRateScenarioArray)bean).getRates();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

