/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.NamedMarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.ImmutableScenarioMarketDataBuilder;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class ImmutableScenarioMarketData
implements ScenarioMarketData,
ImmutableBean,
Serializable {
    private static final ImmutableScenarioMarketData EMPTY = new ImmutableScenarioMarketData(0, MarketDataBox.empty(), (Map<? extends MarketDataId<?>, MarketDataBox<?>>)ImmutableMap.of(), (Map<? extends ObservableId, LocalDateDoubleTimeSeries>)ImmutableMap.of());
    @PropertyDefinition(validate="ArgChecker.notNegative", overrideGet=true)
    private final int scenarioCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final MarketDataBox<LocalDate> valuationDate;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends MarketDataId<?>, MarketDataBox<?>>")
    private final ImmutableMap<MarketDataId<?>, MarketDataBox<?>> values;
    @PropertyDefinition(validate="notNull", builderType="Map<? extends ObservableId, LocalDateDoubleTimeSeries>")
    private final ImmutableMap<ObservableId, LocalDateDoubleTimeSeries> timeSeries;
    private static final long serialVersionUID = 1L;

    public static ImmutableScenarioMarketData of(int scenarioCount, LocalDate valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        return ImmutableScenarioMarketData.of(scenarioCount, MarketDataBox.ofSingleValue(valuationDate), values, timeSeries);
    }

    public static ImmutableScenarioMarketData of(int scenarioCount, MarketDataBox<LocalDate> valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        MapStream.of(values).forEach((key, value) -> ImmutableScenarioMarketData.checkType(key, value, scenarioCount));
        return new ImmutableScenarioMarketData(scenarioCount, valuationDate, values, timeSeries);
    }

    static void checkType(MarketDataId<?> id, MarketDataBox<?> box, int scenarioCount) {
        if (box == null) {
            throw new IllegalArgumentException(Messages.format((String)"Value for identifier '{}' must not be null", id));
        }
        if (box.isScenarioValue() && box.getScenarioCount() != scenarioCount) {
            throw new IllegalArgumentException(Messages.format((String)"Value for identifier '{}' should have had {} scenarios but had {}", (Object[])new Object[]{id, scenarioCount, box.getScenarioCount()}));
        }
        if (box.getScenarioCount() > 0 && !id.getMarketDataType().isInstance(box.getValue(0))) {
            throw new ClassCastException(Messages.format((String)"Value for identifier '{}' does not implement expected type '{}': '{}'", (Object[])new Object[]{id, id.getMarketDataType().getSimpleName(), box}));
        }
    }

    public static ImmutableScenarioMarketData empty() {
        return EMPTY;
    }

    public static ImmutableScenarioMarketDataBuilder builder(LocalDate valuationDate) {
        return new ImmutableScenarioMarketDataBuilder(valuationDate);
    }

    public static ImmutableScenarioMarketDataBuilder builder(MarketDataBox<LocalDate> valuationDate) {
        return new ImmutableScenarioMarketDataBuilder(valuationDate);
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        return this.values.containsKey(id);
    }

    @Override
    public <T> MarketDataBox<T> getValue(MarketDataId<T> id) {
        MarketDataBox value = (MarketDataBox)this.values.get(id);
        if (value == null) {
            throw new MarketDataNotFoundException(this.msgValueNotFound(id));
        }
        return value;
    }

    private String msgValueNotFound(MarketDataId<?> id) {
        return Messages.format((String)"Market data not found for identifier '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()});
    }

    @Override
    public <T> Optional<MarketDataBox<T>> findValue(MarketDataId<T> id) {
        MarketDataBox value = (MarketDataBox)this.values.get(id);
        return Optional.ofNullable(value);
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return this.values.keySet();
    }

    @Override
    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return (Set)this.values.keySet().stream().filter(id -> id instanceof NamedMarketDataId).filter(id -> ((NamedMarketDataId)id).getMarketDataName().equals(name)).map(id -> id).collect(Guavate.toImmutableSet());
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return this.timeSeries.keySet();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        LocalDateDoubleTimeSeries found = (LocalDateDoubleTimeSeries)this.timeSeries.get((Object)id);
        return found == null ? LocalDateDoubleTimeSeries.empty() : found;
    }

    public ImmutableScenarioMarketData combinedWith(ImmutableScenarioMarketData other) {
        if (this.scenarioCount != 1 && other.scenarioCount != 1 && this.scenarioCount != other.scenarioCount) {
            throw new IllegalArgumentException(Messages.format((String)"When merging scenario market data, both sets of data must have the same number of scenarios or at least one of them must have one scenario. Number of scenarios: {} and {}", (Object[])new Object[]{this.scenarioCount, other.scenarioCount}));
        }
        int mergedCount = Math.max(this.scenarioCount, other.scenarioCount);
        HashMap values = new HashMap((Map<MarketDataId<?>, MarketDataBox<?>>)other.values);
        values.putAll((Map<MarketDataId<?>, MarketDataBox<?>>)this.values);
        HashMap<ObservableId, LocalDateDoubleTimeSeries> timeSeries = new HashMap<ObservableId, LocalDateDoubleTimeSeries>((Map<ObservableId, LocalDateDoubleTimeSeries>)other.timeSeries);
        timeSeries.putAll((Map<ObservableId, LocalDateDoubleTimeSeries>)this.timeSeries);
        return new ImmutableScenarioMarketData(mergedCount, this.valuationDate, values, timeSeries);
    }

    @Override
    public ScenarioMarketData combinedWith(ScenarioMarketData other) {
        if (other instanceof ImmutableScenarioMarketData) {
            return this.combinedWith((ImmutableScenarioMarketData)other);
        }
        return ScenarioMarketData.super.combinedWith(other);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    ImmutableScenarioMarketData(int scenarioCount, MarketDataBox<LocalDate> valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        ArgChecker.notNegative((int)scenarioCount, (String)"scenarioCount");
        JodaBeanUtils.notNull(valuationDate, (String)"valuationDate");
        JodaBeanUtils.notNull(values, (String)"values");
        JodaBeanUtils.notNull(timeSeries, (String)"timeSeries");
        this.scenarioCount = scenarioCount;
        this.valuationDate = valuationDate;
        this.values = ImmutableMap.copyOf(values);
        this.timeSeries = ImmutableMap.copyOf(timeSeries);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public int getScenarioCount() {
        return this.scenarioCount;
    }

    @Override
    public MarketDataBox<LocalDate> getValuationDate() {
        return this.valuationDate;
    }

    public ImmutableMap<MarketDataId<?>, MarketDataBox<?>> getValues() {
        return this.values;
    }

    public ImmutableMap<ObservableId, LocalDateDoubleTimeSeries> getTimeSeries() {
        return this.timeSeries;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableScenarioMarketData other = (ImmutableScenarioMarketData)obj;
            return this.scenarioCount == other.scenarioCount && JodaBeanUtils.equal(this.valuationDate, other.valuationDate) && JodaBeanUtils.equal(this.values, other.values) && JodaBeanUtils.equal(this.timeSeries, other.timeSeries);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.scenarioCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.values);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.timeSeries);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ImmutableScenarioMarketData{");
        buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString(this.valuationDate)).append(',').append(' ');
        buf.append("values").append('=').append(JodaBeanUtils.toString(this.values)).append(',').append(' ');
        buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ImmutableScenarioMarketData> {
        private int scenarioCount;
        private MarketDataBox<LocalDate> valuationDate;
        private Map<? extends MarketDataId<?>, MarketDataBox<?>> values = ImmutableMap.of();
        private Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return this.scenarioCount;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case -823812830: {
                    return this.values;
                }
                case 779431844: {
                    return this.timeSeries;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    this.scenarioCount = (Integer)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (MarketDataBox)newValue;
                    break;
                }
                case -823812830: {
                    this.values = (Map)newValue;
                    break;
                }
                case 779431844: {
                    this.timeSeries = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ImmutableScenarioMarketData build() {
            return new ImmutableScenarioMarketData(this.scenarioCount, this.valuationDate, this.values, this.timeSeries);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableScenarioMarketData.Builder{");
            buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString(this.valuationDate)).append(',').append(' ');
            buf.append("values").append('=').append(JodaBeanUtils.toString(this.values)).append(',').append(' ');
            buf.append("timeSeries").append('=').append(JodaBeanUtils.toString(this.timeSeries));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> scenarioCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"scenarioCount", ImmutableScenarioMarketData.class, Integer.TYPE);
        private final MetaProperty<MarketDataBox<LocalDate>> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", ImmutableScenarioMarketData.class, MarketDataBox.class);
        private final MetaProperty<ImmutableMap<MarketDataId<?>, MarketDataBox<?>>> values = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"values", ImmutableScenarioMarketData.class, ImmutableMap.class);
        private final MetaProperty<ImmutableMap<ObservableId, LocalDateDoubleTimeSeries>> timeSeries = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeSeries", ImmutableScenarioMarketData.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"scenarioCount", "valuationDate", "values", "timeSeries"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return this.scenarioCount;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case -823812830: {
                    return this.values;
                }
                case 779431844: {
                    return this.timeSeries;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ImmutableScenarioMarketData> builder() {
            return new Builder();
        }

        public Class<? extends ImmutableScenarioMarketData> beanType() {
            return ImmutableScenarioMarketData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> scenarioCount() {
            return this.scenarioCount;
        }

        public MetaProperty<MarketDataBox<LocalDate>> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<ImmutableMap<MarketDataId<?>, MarketDataBox<?>>> values() {
            return this.values;
        }

        public MetaProperty<ImmutableMap<ObservableId, LocalDateDoubleTimeSeries>> timeSeries() {
            return this.timeSeries;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return ((ImmutableScenarioMarketData)bean).getScenarioCount();
                }
                case 113107279: {
                    return ((ImmutableScenarioMarketData)bean).getValuationDate();
                }
                case -823812830: {
                    return ((ImmutableScenarioMarketData)bean).getValues();
                }
                case 779431844: {
                    return ((ImmutableScenarioMarketData)bean).getTimeSeries();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

