/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.ImmutableScenarioMarketData;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ImmutableScenarioMarketDataBuilder {
    private int scenarioCount;
    private final MarketDataBox<LocalDate> valuationDate;
    private final Map<MarketDataId<?>, MarketDataBox<?>> values = new HashMap();
    private final Map<ObservableId, LocalDateDoubleTimeSeries> timeSeries = new HashMap<ObservableId, LocalDateDoubleTimeSeries>();

    ImmutableScenarioMarketDataBuilder(LocalDate valuationDate) {
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        this.scenarioCount = -1;
        this.valuationDate = MarketDataBox.ofSingleValue(valuationDate);
    }

    ImmutableScenarioMarketDataBuilder(MarketDataBox<LocalDate> valuationDate) {
        ArgChecker.notNull(valuationDate, (String)"valuationDate");
        this.scenarioCount = -1;
        this.valuationDate = valuationDate;
    }

    ImmutableScenarioMarketDataBuilder(int scenarioCount, MarketDataBox<LocalDate> valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        ArgChecker.notNegative((int)scenarioCount, (String)"scenarioCount");
        ArgChecker.notNull(valuationDate, (String)"valuationDate");
        ArgChecker.notNull(values, (String)"values");
        ArgChecker.notNull(timeSeries, (String)"timeSeries");
        this.scenarioCount = scenarioCount;
        this.valuationDate = valuationDate;
        this.values.putAll(values);
        this.timeSeries.putAll(timeSeries);
    }

    public ImmutableScenarioMarketDataBuilder values(Map<? extends MarketDataId<?>, ?> values) {
        this.values.clear();
        return this.addValueMap(values);
    }

    public ImmutableScenarioMarketDataBuilder timeSeries(Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        this.timeSeries.clear();
        return this.addTimeSeriesMap(timeSeries);
    }

    public <T> ImmutableScenarioMarketDataBuilder addValue(MarketDataId<T> id, T value) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(value, (String)"value");
        this.values.put(id, MarketDataBox.ofSingleValue(value));
        return this;
    }

    public ImmutableScenarioMarketDataBuilder addValueMap(Map<? extends MarketDataId<?>, ?> values) {
        ArgChecker.notNull(values, (String)"values");
        for (Map.Entry<MarketDataId<?>, ?> entry : values.entrySet()) {
            MarketDataId<?> id = entry.getKey();
            Object value = entry.getValue();
            MarketDataBox<?> box = MarketDataBox.ofSingleValue(value);
            ImmutableScenarioMarketDataBuilder.checkBoxType(id, box);
            this.checkAndUpdateScenarioCount(box);
            this.values.put(id, box);
        }
        return this;
    }

    public <T> ImmutableScenarioMarketDataBuilder addScenarioValue(MarketDataId<T> id, List<? extends T> values) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(values, (String)"values");
        MarketDataBox<? extends T> box = MarketDataBox.ofScenarioValues(values);
        this.checkAndUpdateScenarioCount(box);
        this.values.put(id, box);
        return this;
    }

    public <T> ImmutableScenarioMarketDataBuilder addScenarioValue(MarketDataId<T> id, ScenarioArray<? extends T> value) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(value, (String)"values");
        MarketDataBox<? extends T> box = MarketDataBox.ofScenarioValue(value);
        this.checkAndUpdateScenarioCount(box);
        this.values.put(id, box);
        return this;
    }

    public ImmutableScenarioMarketDataBuilder addScenarioValueMap(Map<? extends MarketDataId<?>, ? extends ScenarioArray<?>> values) {
        ArgChecker.notNull(values, (String)"values");
        for (Map.Entry<MarketDataId<?>, ScenarioArray<?>> entry : values.entrySet()) {
            MarketDataId<?> id = entry.getKey();
            ScenarioArray<?> value = entry.getValue();
            MarketDataBox<?> box = MarketDataBox.ofScenarioValue(value);
            ImmutableScenarioMarketDataBuilder.checkBoxType(id, box);
            this.checkAndUpdateScenarioCount(box);
            this.values.put(id, box);
        }
        return this;
    }

    public <T> ImmutableScenarioMarketDataBuilder addBox(MarketDataId<T> id, MarketDataBox<? extends T> value) {
        ArgChecker.notNull(id, (String)"id");
        ArgChecker.notNull(value, (String)"value");
        this.checkAndUpdateScenarioCount(value);
        this.values.put(id, value);
        return this;
    }

    public ImmutableScenarioMarketDataBuilder addBoxMap(Map<? extends MarketDataId<?>, ? extends MarketDataBox<?>> values) {
        ArgChecker.notNull(values, (String)"values");
        for (Map.Entry<MarketDataId<?>, MarketDataBox<?>> entry : values.entrySet()) {
            MarketDataId<?> id = entry.getKey();
            MarketDataBox<?> box = entry.getValue();
            ImmutableScenarioMarketDataBuilder.checkBoxType(id, box);
            this.checkAndUpdateScenarioCount(box);
            this.values.put(id, box);
        }
        return this;
    }

    public ImmutableScenarioMarketDataBuilder addTimeSeries(ObservableId id, LocalDateDoubleTimeSeries timeSeries) {
        ArgChecker.notNull((Object)id, (String)"id");
        ArgChecker.notNull((Object)timeSeries, (String)"timeSeries");
        this.timeSeries.put(id, timeSeries);
        return this;
    }

    public ImmutableScenarioMarketDataBuilder addTimeSeriesMap(Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeriesMap) {
        ArgChecker.notNull(timeSeriesMap, (String)"timeSeriesMap");
        this.timeSeries.putAll(timeSeriesMap);
        return this;
    }

    private static void checkBoxType(MarketDataId<?> id, MarketDataBox<?> box) {
        if (!id.getMarketDataType().isAssignableFrom(box.getMarketDataType())) {
            throw new IllegalArgumentException(Messages.format((String)"Market data type {} of value {} is not compatible with the market data type of the identifier {}", (Object[])new Object[]{box.getMarketDataType().getName(), box, id.getMarketDataType().getName()}));
        }
    }

    private void checkAndUpdateScenarioCount(MarketDataBox<?> value) {
        if (value.isScenarioValue()) {
            if (this.scenarioCount == -1) {
                this.scenarioCount = value.getScenarioCount();
            } else if (value.getScenarioCount() != this.scenarioCount) {
                throw new IllegalArgumentException(Messages.format((String)"All values must have the same number of scenarios, expecting {} but received {}", (Object[])new Object[]{this.scenarioCount, value.getScenarioCount()}));
            }
        }
    }

    public ImmutableScenarioMarketData build() {
        if (this.scenarioCount == -1) {
            this.scenarioCount = 1;
        }
        return new ImmutableScenarioMarketData(this.scenarioCount, this.valuationDate, this.values, this.timeSeries);
    }
}

