/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.collect.function.ObjIntFunction;
import com.opengamma.strata.data.scenario.EmptyMarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketDataBox;
import com.opengamma.strata.data.scenario.SingleMarketDataBox;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public interface MarketDataBox<T> {
    public static <T> MarketDataBox<T> ofSingleValue(T singleValue) {
        return SingleMarketDataBox.of(singleValue);
    }

    public static <T> MarketDataBox<T> ofScenarioValue(ScenarioArray<T> scenarioValue) {
        return ScenarioMarketDataBox.of(scenarioValue);
    }

    @SafeVarargs
    public static <T> MarketDataBox<T> ofScenarioValues(T ... scenarioValues) {
        return ScenarioMarketDataBox.of(scenarioValues);
    }

    public static <T> MarketDataBox<T> ofScenarioValues(List<T> scenarioValues) {
        return ScenarioMarketDataBox.of(scenarioValues);
    }

    public static <T> MarketDataBox<T> empty() {
        return EmptyMarketDataBox.empty();
    }

    public T getSingleValue();

    public ScenarioArray<T> getScenarioValue();

    public T getValue(int var1);

    public boolean isSingleValue();

    default public boolean isScenarioValue() {
        return !this.isSingleValue();
    }

    public int getScenarioCount();

    public Class<?> getMarketDataType();

    public <R> MarketDataBox<R> map(Function<T, R> var1);

    public <R> MarketDataBox<R> mapWithIndex(int var1, ObjIntFunction<T, R> var2);

    public <U, R> MarketDataBox<R> combineWith(MarketDataBox<U> var1, BiFunction<T, U, R> var2);

    public Stream<T> stream();
}

