/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyAmountArray;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmountArray;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.MapStream;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioFxConvertible;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class MultiCurrencyScenarioArray
implements ScenarioArray<MultiCurrencyAmount>,
ScenarioFxConvertible<CurrencyScenarioArray>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final MultiCurrencyAmountArray amounts;
    private static final long serialVersionUID = 1L;

    public static MultiCurrencyScenarioArray of(MultiCurrencyAmountArray amounts) {
        return new MultiCurrencyScenarioArray(amounts);
    }

    public static MultiCurrencyScenarioArray of(MultiCurrencyAmount ... amounts) {
        return MultiCurrencyScenarioArray.of(Arrays.asList(amounts));
    }

    public static MultiCurrencyScenarioArray of(List<MultiCurrencyAmount> amounts) {
        return new MultiCurrencyScenarioArray(MultiCurrencyAmountArray.of(amounts));
    }

    public static MultiCurrencyScenarioArray of(int size, IntFunction<MultiCurrencyAmount> amountFunction) {
        return new MultiCurrencyScenarioArray(MultiCurrencyAmountArray.of((int)size, amountFunction));
    }

    public static MultiCurrencyScenarioArray of(Map<Currency, DoubleArray> values) {
        return new MultiCurrencyScenarioArray(MultiCurrencyAmountArray.of(values));
    }

    public Set<Currency> getCurrencies() {
        return this.amounts.getCurrencies();
    }

    public DoubleArray getValues(Currency currency) {
        DoubleArray currencyValues = this.amounts.getValues(currency);
        if (currencyValues == null) {
            throw new IllegalArgumentException("No values available for " + currency);
        }
        return currencyValues;
    }

    @Override
    public int getScenarioCount() {
        return this.amounts.size();
    }

    @Override
    public MultiCurrencyAmount get(int index) {
        List currencyAmounts = this.amounts.getCurrencies().stream().map(ccy -> CurrencyAmount.of((Currency)ccy, (double)this.amounts.getValues(ccy).get(index))).collect(Collectors.toList());
        return MultiCurrencyAmount.of(currencyAmounts);
    }

    @Override
    public Stream<MultiCurrencyAmount> stream() {
        return this.amounts.stream();
    }

    @Override
    public CurrencyScenarioArray convertedTo(Currency reportingCurrency, ScenarioFxRateProvider fxRateProvider) {
        int size = this.getScenarioCount();
        if (fxRateProvider.getScenarioCount() != size) {
            throw new IllegalArgumentException(Messages.format((String)"Expected {} FX rates but received {}", (Object[])new Object[]{size, fxRateProvider.getScenarioCount()}));
        }
        double[] singleCurrencyValues = new double[size];
        for (Map.Entry entry : this.amounts.getValues().entrySet()) {
            Currency currency = (Currency)entry.getKey();
            DoubleArray currencyValues = (DoubleArray)entry.getValue();
            int i = 0;
            while (i < size) {
                double convertedValue = currencyValues.get(i) * fxRateProvider.fxRate(currency, reportingCurrency, i);
                int n = i++;
                singleCurrencyValues[n] = singleCurrencyValues[n] + convertedValue;
            }
        }
        return CurrencyScenarioArray.of(reportingCurrency, DoubleArray.ofUnsafe((double[])singleCurrencyValues));
    }

    public static MultiCurrencyScenarioArray total(Iterable<CurrencyScenarioArray> arrays) {
        return Guavate.stream(arrays).collect(MultiCurrencyScenarioArray.toMultiCurrencyScenarioArray());
    }

    public static Collector<CurrencyScenarioArray, ?, MultiCurrencyScenarioArray> toMultiCurrencyScenarioArray() {
        return Collector.of(HashMap::new, (A map, T ca) -> map.merge(ca.getCurrency(), ca.getAmounts(), CurrencyAmountArray::plus), (map1, map2) -> {
            map2.values().forEach(ca2 -> map1.merge(ca2.getCurrency(), ca2, CurrencyAmountArray::plus));
            return map1;
        }, (A map) -> {
            ImmutableMap currencyArrayMap = MapStream.of((Map)map).mapValues(caa -> caa.getValues()).toMap();
            return MultiCurrencyScenarioArray.of((Map<Currency, DoubleArray>)currencyArrayMap);
        }, Collector.Characteristics.UNORDERED);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private MultiCurrencyScenarioArray(MultiCurrencyAmountArray amounts) {
        JodaBeanUtils.notNull((Object)amounts, (String)"amounts");
        this.amounts = amounts;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public MultiCurrencyAmountArray getAmounts() {
        return this.amounts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            MultiCurrencyScenarioArray other = (MultiCurrencyScenarioArray)obj;
            return JodaBeanUtils.equal((Object)this.amounts, (Object)other.amounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.amounts);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("MultiCurrencyScenarioArray{");
        buf.append("amounts").append('=').append(JodaBeanUtils.toString((Object)this.amounts));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<MultiCurrencyScenarioArray> {
        private MultiCurrencyAmountArray amounts;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    this.amounts = (MultiCurrencyAmountArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public MultiCurrencyScenarioArray build() {
            return new MultiCurrencyScenarioArray(this.amounts);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("MultiCurrencyScenarioArray.Builder{");
            buf.append("amounts").append('=').append(JodaBeanUtils.toString((Object)this.amounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<MultiCurrencyAmountArray> amounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amounts", MultiCurrencyScenarioArray.class, MultiCurrencyAmountArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"amounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return this.amounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends MultiCurrencyScenarioArray> builder() {
            return new Builder();
        }

        public Class<? extends MultiCurrencyScenarioArray> beanType() {
            return MultiCurrencyScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<MultiCurrencyAmountArray> amounts() {
            return this.amounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -879772901: {
                    return ((MultiCurrencyScenarioArray)bean).getAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

