/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.google.common.base.Preconditions;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
final class RepeatedScenarioMarketData
implements ScenarioMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero", overrideGet=true)
    private final int scenarioCount;
    @PropertyDefinition(validate="notNull")
    private final MarketData underlying;
    private static final long serialVersionUID = 1L;

    public static RepeatedScenarioMarketData of(int scenarioCount, MarketData marketData) {
        return new RepeatedScenarioMarketData(scenarioCount, marketData);
    }

    @Override
    public MarketDataBox<LocalDate> getValuationDate() {
        return MarketDataBox.ofSingleValue(this.underlying.getValuationDate());
    }

    @Override
    public Stream<MarketData> scenarios() {
        return IntStream.range(0, this.getScenarioCount()).mapToObj(scenarioIndex -> this.underlying);
    }

    @Override
    public MarketData scenario(int scenarioIndex) {
        Preconditions.checkElementIndex((int)scenarioIndex, (int)this.scenarioCount, (String)"scenarioIndex");
        return this.underlying;
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        return this.underlying.containsValue(id);
    }

    @Override
    public <T> MarketDataBox<T> getValue(MarketDataId<T> id) {
        return MarketDataBox.ofSingleValue(this.underlying.getValue(id));
    }

    @Override
    public <T> Optional<MarketDataBox<T>> findValue(MarketDataId<T> id) {
        return this.underlying.findValue(id).map(v -> MarketDataBox.ofSingleValue(v));
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return this.underlying.getIds();
    }

    @Override
    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return this.underlying.findIds(name);
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return this.underlying.getTimeSeriesIds();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        return this.underlying.getTimeSeries(id);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    RepeatedScenarioMarketData(int scenarioCount, MarketData underlying) {
        ArgChecker.notNegativeOrZero((int)scenarioCount, (String)"scenarioCount");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.scenarioCount = scenarioCount;
        this.underlying = underlying;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public int getScenarioCount() {
        return this.scenarioCount;
    }

    public MarketData getUnderlying() {
        return this.underlying;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            RepeatedScenarioMarketData other = (RepeatedScenarioMarketData)obj;
            return this.scenarioCount == other.scenarioCount && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.scenarioCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("RepeatedScenarioMarketData{");
        buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount)).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<RepeatedScenarioMarketData> {
        private int scenarioCount;
        private MarketData underlying;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return this.scenarioCount;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    this.scenarioCount = (Integer)newValue;
                    break;
                }
                case -1770633379: {
                    this.underlying = (MarketData)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public RepeatedScenarioMarketData build() {
            return new RepeatedScenarioMarketData(this.scenarioCount, this.underlying);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("RepeatedScenarioMarketData.Builder{");
            buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount)).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> scenarioCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"scenarioCount", RepeatedScenarioMarketData.class, Integer.TYPE);
        private final MetaProperty<MarketData> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", RepeatedScenarioMarketData.class, MarketData.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"scenarioCount", "underlying"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return this.scenarioCount;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends RepeatedScenarioMarketData> builder() {
            return new Builder();
        }

        public Class<? extends RepeatedScenarioMarketData> beanType() {
            return RepeatedScenarioMarketData.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> scenarioCount() {
            return this.scenarioCount;
        }

        public MetaProperty<MarketData> underlying() {
            return this.underlying;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return ((RepeatedScenarioMarketData)bean).getScenarioCount();
                }
                case -1770633379: {
                    return ((RepeatedScenarioMarketData)bean).getUnderlying();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

