/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.data.scenario.DefaultScenarioArray;
import com.opengamma.strata.data.scenario.SingleScenarioArray;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface ScenarioArray<T> {
    @SafeVarargs
    public static <T> ScenarioArray<T> of(T ... values) {
        return DefaultScenarioArray.of(values);
    }

    public static <T> ScenarioArray<T> of(List<T> values) {
        return DefaultScenarioArray.of(values);
    }

    public static <T> ScenarioArray<T> of(int scenarioCount, IntFunction<T> valueFunction) {
        return DefaultScenarioArray.of(scenarioCount, valueFunction);
    }

    public static <T> ScenarioArray<T> ofSingleValue(int scenarioCount, T value) {
        return SingleScenarioArray.of(scenarioCount, value);
    }

    public int getScenarioCount();

    public T get(int var1);

    default public Stream<T> stream() {
        return IntStream.range(0, this.getScenarioCount()).mapToObj(i -> this.get(i));
    }
}

