/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.data.ObservableSource;
import com.opengamma.strata.data.scenario.DefaultScenarioFxRateProvider;
import com.opengamma.strata.data.scenario.ScenarioMarketData;

public interface ScenarioFxRateProvider {
    public static ScenarioFxRateProvider of(ScenarioMarketData marketData) {
        return new DefaultScenarioFxRateProvider(marketData, ObservableSource.NONE);
    }

    public static ScenarioFxRateProvider of(ScenarioMarketData marketData, ObservableSource source) {
        return new DefaultScenarioFxRateProvider(marketData, source);
    }

    public int getScenarioCount();

    default public double convert(double amount, Currency fromCurrency, Currency toCurrency, int scenarioIndex) {
        if (fromCurrency.equals((Object)toCurrency)) {
            return amount;
        }
        return amount * this.fxRate(fromCurrency, toCurrency, scenarioIndex);
    }

    default public double fxRate(Currency baseCurrency, Currency counterCurrency, int scenarioIndex) {
        if (baseCurrency.equals((Object)counterCurrency)) {
            return 1.0;
        }
        return this.fxRateProvider(scenarioIndex).fxRate(baseCurrency, counterCurrency);
    }

    public FxRateProvider fxRateProvider(int var1);
}

