/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.CombinedScenarioMarketData;
import com.opengamma.strata.data.scenario.ExtendedScenarioMarketData;
import com.opengamma.strata.data.scenario.ImmutableScenarioMarketData;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.RepeatedScenarioMarketData;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketDataId;
import com.opengamma.strata.data.scenario.ScenarioPerturbation;
import com.opengamma.strata.data.scenario.SingleScenarioMarketData;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public interface ScenarioMarketData {
    public static ScenarioMarketData of(int scenarioCount, LocalDate valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        return ScenarioMarketData.of(scenarioCount, MarketDataBox.ofSingleValue(valuationDate), values, timeSeries);
    }

    public static ScenarioMarketData of(int scenarioCount, MarketDataBox<LocalDate> valuationDate, Map<? extends MarketDataId<?>, MarketDataBox<?>> values, Map<? extends ObservableId, LocalDateDoubleTimeSeries> timeSeries) {
        return ImmutableScenarioMarketData.of(scenarioCount, valuationDate, values, timeSeries);
    }

    public static ScenarioMarketData of(int scenarioCount, MarketData marketData) {
        return RepeatedScenarioMarketData.of(scenarioCount, marketData);
    }

    public static ScenarioMarketData empty() {
        return ImmutableScenarioMarketData.empty();
    }

    public MarketDataBox<LocalDate> getValuationDate();

    public int getScenarioCount();

    default public Stream<MarketData> scenarios() {
        return IntStream.range(0, this.getScenarioCount()).mapToObj(scenarioIndex -> SingleScenarioMarketData.of(this, scenarioIndex));
    }

    default public MarketData scenario(int scenarioIndex) {
        return SingleScenarioMarketData.of(this, scenarioIndex);
    }

    default public boolean containsValue(MarketDataId<?> id) {
        return this.findValue(id).isPresent();
    }

    default public <T> MarketDataBox<T> getValue(MarketDataId<T> id) {
        return this.findValue(id).orElseThrow(() -> new MarketDataNotFoundException(Messages.format((String)"Market data not found for '{}' of type '{}'", (Object[])new Object[]{id, id.getClass().getSimpleName()})));
    }

    public <T> Optional<MarketDataBox<T>> findValue(MarketDataId<T> var1);

    public Set<MarketDataId<?>> getIds();

    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> var1);

    default public <T, U extends ScenarioArray<T>> U getScenarioValue(ScenarioMarketDataId<T, U> id) {
        MarketDataBox<T> box = this.getValue(id.getMarketDataId());
        if (box.isSingleValue()) {
            return id.createScenarioValue(box, this.getScenarioCount());
        }
        ScenarioArray<T> scenarioValue = box.getScenarioValue();
        if (id.getScenarioMarketDataType().isInstance(scenarioValue)) {
            return (U)scenarioValue;
        }
        return id.createScenarioValue(box, this.getScenarioCount());
    }

    default public ScenarioMarketData combinedWith(ScenarioMarketData other) {
        return new CombinedScenarioMarketData(this, other);
    }

    public Set<ObservableId> getTimeSeriesIds();

    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId var1);

    default public <T> ScenarioMarketData withValue(MarketDataId<T> id, MarketDataBox<T> value) {
        return ExtendedScenarioMarketData.of(id, value, this);
    }

    default public <T> ScenarioMarketData withPerturbation(MarketDataId<T> id, ScenarioPerturbation<T> perturbation, ReferenceData refData) {
        if (perturbation.getScenarioCount() != 1 && perturbation.getScenarioCount() != this.getScenarioCount()) {
            throw new IllegalArgumentException(Messages.format((String)"Scenario count mismatch: perturbation has {} scenarios but this market data has {}", (Object[])new Object[]{perturbation.getScenarioCount(), this.getScenarioCount()}));
        }
        return this.withValue(id, perturbation.applyTo(this.getValue(id), refData));
    }
}

