/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.function.ObjIntFunction;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
final class ScenarioMarketDataBox<T>
implements ImmutableBean,
MarketDataBox<T>,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ScenarioArray<T> value;
    private static final long serialVersionUID = 1L;

    public static <T> ScenarioMarketDataBox<T> of(ScenarioArray<T> value) {
        return new ScenarioMarketDataBox<T>(value);
    }

    @SafeVarargs
    public static <T> ScenarioMarketDataBox<T> of(T ... values) {
        return new ScenarioMarketDataBox<T>(ScenarioArray.of(values));
    }

    public static <T> ScenarioMarketDataBox<T> of(List<T> values) {
        return new ScenarioMarketDataBox<T>(ScenarioArray.of(values));
    }

    @Override
    public T getSingleValue() {
        throw new IllegalStateException("This box does not contain a single value");
    }

    @Override
    public ScenarioArray<T> getScenarioValue() {
        return this.value;
    }

    @Override
    public T getValue(int scenarioIndex) {
        ArgChecker.inRange((int)scenarioIndex, (int)0, (int)this.value.getScenarioCount(), (String)"scenarioIndex");
        return this.value.get(scenarioIndex);
    }

    @Override
    public boolean isSingleValue() {
        return false;
    }

    @Override
    public int getScenarioCount() {
        return this.value.getScenarioCount();
    }

    @Override
    public Class<?> getMarketDataType() {
        return this.value.get(0).getClass();
    }

    @Override
    public <R> MarketDataBox<R> map(Function<T, R> fn) {
        return this.applyToScenarios(i -> fn.apply(this.value.get((int)i)));
    }

    @Override
    public <R> MarketDataBox<R> mapWithIndex(int scenarioCount, ObjIntFunction<T, R> fn) {
        if (scenarioCount != this.getScenarioCount()) {
            throw new IllegalArgumentException(Messages.format((String)"Scenario count {} does not equal the scenario count of the value {}", (Object[])new Object[]{scenarioCount, this.getScenarioCount()}));
        }
        List perturbedValues = (List)IntStream.range(0, scenarioCount).mapToObj(idx -> fn.apply(this.getValue(idx), idx)).collect(Guavate.toImmutableList());
        return MarketDataBox.ofScenarioValues(perturbedValues);
    }

    @Override
    public <U, R> MarketDataBox<R> combineWith(MarketDataBox<U> other, BiFunction<T, U, R> fn) {
        return other.isSingleValue() ? this.combineWithSingle(other, fn) : this.combineWithMultiple(other, fn);
    }

    private <R, U> MarketDataBox<R> combineWithMultiple(MarketDataBox<U> other, BiFunction<T, U, R> fn) {
        ScenarioArray otherValue = other.getScenarioValue();
        if (otherValue.getScenarioCount() != this.value.getScenarioCount()) {
            String message = Messages.format((String)"Scenario values must have the same number of scenarios. {} has {} scenarios, {} has {}", (Object[])new Object[]{this.value, this.value.getScenarioCount(), otherValue, otherValue.getScenarioCount()});
            throw new IllegalArgumentException(message);
        }
        return this.applyToScenarios(i -> fn.apply(this.value.get((int)i), otherValue.get((int)i)));
    }

    private <U, R> MarketDataBox<R> combineWithSingle(MarketDataBox<U> other, BiFunction<T, U, R> fn) {
        Object otherValue = other.getSingleValue();
        return this.applyToScenarios(i -> fn.apply(this.value.get((int)i), otherValue));
    }

    private <R> MarketDataBox<R> applyToScenarios(Function<Integer, R> fn) {
        List results = (List)IntStream.range(0, this.value.getScenarioCount()).mapToObj(fn::apply).collect(Guavate.toImmutableList());
        return MarketDataBox.ofScenarioValues(results);
    }

    @Override
    public Stream<T> stream() {
        return this.value.stream();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaScenarioMarketDataBox(Class<R> cls) {
        return Meta.INSTANCE;
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    private ScenarioMarketDataBox(ScenarioArray<T> value) {
        JodaBeanUtils.notNull(value, (String)"value");
        this.value = value;
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public ScenarioArray<T> getValue() {
        return this.value;
    }

    Builder<T> toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ScenarioMarketDataBox other = (ScenarioMarketDataBox)obj;
            return JodaBeanUtils.equal(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("ScenarioMarketDataBox{");
        buf.append("value").append('=').append(JodaBeanUtils.toString(this.value));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    static final class Builder<T>
    extends DirectFieldsBeanBuilder<ScenarioMarketDataBox<T>> {
        private ScenarioArray<T> value;

        private Builder() {
        }

        private Builder(ScenarioMarketDataBox<T> beanToCopy) {
            this.value = beanToCopy.getValue();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = (ScenarioArray)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder<T> set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ScenarioMarketDataBox<T> build() {
            return new ScenarioMarketDataBox(this.value);
        }

        public Builder<T> value(ScenarioArray<T> value) {
            JodaBeanUtils.notNull(value, (String)"value");
            this.value = value;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("ScenarioMarketDataBox.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString(this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ScenarioArray<T>> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", ScenarioMarketDataBox.class, ScenarioArray.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder<T> builder() {
            return new Builder();
        }

        public Class<? extends ScenarioMarketDataBox<T>> beanType() {
            return ScenarioMarketDataBox.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ScenarioArray<T>> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((ScenarioMarketDataBox)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

