/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.function.ObjIntFunction;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioArray;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
final class SingleMarketDataBox<T>
implements ImmutableBean,
MarketDataBox<T>,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final T value;
    private static final long serialVersionUID = 1L;

    public static <T> SingleMarketDataBox<T> of(T value) {
        return new SingleMarketDataBox<T>(value);
    }

    @Override
    public T getSingleValue() {
        return this.value;
    }

    @Override
    public ScenarioArray<T> getScenarioValue() {
        throw new IllegalStateException("This box does not contain a scenario value");
    }

    @Override
    public T getValue(int scenarioIndex) {
        ArgChecker.notNegative((int)scenarioIndex, (String)"scenarioIndex");
        return this.value;
    }

    @Override
    public boolean isSingleValue() {
        return true;
    }

    @Override
    public int getScenarioCount() {
        return -1;
    }

    @Override
    public Class<?> getMarketDataType() {
        return this.value.getClass();
    }

    @Override
    public <R> MarketDataBox<R> map(Function<T, R> fn) {
        return MarketDataBox.ofSingleValue(fn.apply(this.value));
    }

    @Override
    public <R> MarketDataBox<R> mapWithIndex(int scenarioCount, ObjIntFunction<T, R> fn) {
        List perturbedValues = (List)IntStream.range(0, scenarioCount).mapToObj(idx -> fn.apply(this.value, idx)).collect(Guavate.toImmutableList());
        return MarketDataBox.ofScenarioValues(perturbedValues);
    }

    @Override
    public <U, R> MarketDataBox<R> combineWith(MarketDataBox<U> other, BiFunction<T, U, R> fn) {
        return other.isSingleValue() ? this.combineWithSingle(other, fn) : this.combineWithMultiple(other, fn);
    }

    private <U, R> MarketDataBox<R> combineWithMultiple(MarketDataBox<U> other, BiFunction<T, U, R> fn) {
        ScenarioArray<U> otherValue = other.getScenarioValue();
        int scenarioCount = otherValue.getScenarioCount();
        List values = (List)IntStream.range(0, scenarioCount).mapToObj(i -> fn.apply(this.value, other.getValue(i))).collect(Guavate.toImmutableList());
        return MarketDataBox.ofScenarioValues(values);
    }

    private <U, R> MarketDataBox<R> combineWithSingle(MarketDataBox<U> other, BiFunction<T, U, R> fn) {
        U otherValue = other.getSingleValue();
        return MarketDataBox.ofSingleValue(fn.apply(this.value, otherValue));
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.value);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaSingleMarketDataBox(Class<R> cls) {
        return Meta.INSTANCE;
    }

    static <T> Builder<T> builder() {
        return new Builder();
    }

    private SingleMarketDataBox(T value) {
        JodaBeanUtils.notNull(value, (String)"value");
        this.value = value;
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    public T getValue() {
        return this.value;
    }

    Builder<T> toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SingleMarketDataBox other = (SingleMarketDataBox)obj;
            return JodaBeanUtils.equal(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("SingleMarketDataBox{");
        buf.append("value").append('=').append(JodaBeanUtils.toString(this.value));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    static final class Builder<T>
    extends DirectFieldsBeanBuilder<SingleMarketDataBox<T>> {
        private T value;

        private Builder() {
        }

        private Builder(SingleMarketDataBox<T> beanToCopy) {
            this.value = beanToCopy.getValue();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    this.value = newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder<T> set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SingleMarketDataBox<T> build() {
            return new SingleMarketDataBox(this.value);
        }

        public Builder<T> value(T value) {
            JodaBeanUtils.notNull(value, (String)"value");
            this.value = value;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("SingleMarketDataBox.Builder{");
            buf.append("value").append('=').append(JodaBeanUtils.toString(this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<T> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", SingleMarketDataBox.class, Object.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder<T> builder() {
            return new Builder();
        }

        public Class<? extends SingleMarketDataBox<T>> beanType() {
            return SingleMarketDataBox.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<T> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 111972721: {
                    return ((SingleMarketDataBox)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

