/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.scenario.DefaultScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioFxConvertible;
import com.opengamma.strata.data.scenario.ScenarioFxRateProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
final class SingleScenarioArray<T>
implements ScenarioArray<T>,
ScenarioFxConvertible<ScenarioArray<?>>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final int scenarioCount;
    @PropertyDefinition(validate="notNull")
    private final T value;
    private static final long serialVersionUID = 1L;

    public static <T> SingleScenarioArray<T> of(int scenarioCount, T value) {
        return new SingleScenarioArray<T>(scenarioCount, value);
    }

    @Override
    public T get(int index) {
        ArgChecker.inRange((int)index, (int)0, (int)this.scenarioCount, (String)"index");
        return this.value;
    }

    @Override
    public Stream<T> stream() {
        return Collections.nCopies(this.scenarioCount, this.value).stream();
    }

    @Override
    public ScenarioArray<?> convertedTo(Currency reportingCurrency, ScenarioFxRateProvider fxRateProvider) {
        if (this.value instanceof FxConvertible) {
            FxConvertible convertible = (FxConvertible)this.value;
            if (fxRateProvider.getScenarioCount() != this.scenarioCount) {
                throw new IllegalArgumentException(Messages.format((String)"Expected {} FX rates but received {}", (Object[])new Object[]{this.scenarioCount, fxRateProvider.getScenarioCount()}));
            }
            ImmutableList converted = (ImmutableList)IntStream.range(0, this.scenarioCount).mapToObj(i -> convertible.convertedTo(reportingCurrency, fxRateProvider.fxRateProvider(i))).collect(Guavate.toImmutableList());
            return DefaultScenarioArray.of(converted);
        }
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R> Meta<R> metaSingleScenarioArray(Class<R> cls) {
        return Meta.INSTANCE;
    }

    private SingleScenarioArray(int scenarioCount, T value) {
        JodaBeanUtils.notNull((Object)scenarioCount, (String)"scenarioCount");
        JodaBeanUtils.notNull(value, (String)"value");
        this.scenarioCount = scenarioCount;
        this.value = value;
    }

    public Meta<T> metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public int getScenarioCount() {
        return this.scenarioCount;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SingleScenarioArray other = (SingleScenarioArray)obj;
            return this.scenarioCount == other.scenarioCount && JodaBeanUtils.equal(this.value, other.value);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.scenarioCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.value);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("SingleScenarioArray{");
        buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount)).append(',').append(' ');
        buf.append("value").append('=').append(JodaBeanUtils.toString(this.value));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<T>
    extends DirectPrivateBeanBuilder<SingleScenarioArray<T>> {
        private int scenarioCount;
        private T value;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return this.scenarioCount;
                }
                case 111972721: {
                    return this.value;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<T> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    this.scenarioCount = (Integer)newValue;
                    break;
                }
                case 111972721: {
                    this.value = newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SingleScenarioArray<T> build() {
            return new SingleScenarioArray(this.scenarioCount, this.value);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("SingleScenarioArray.Builder{");
            buf.append("scenarioCount").append('=').append(JodaBeanUtils.toString((Object)this.scenarioCount)).append(',').append(' ');
            buf.append("value").append('=').append(JodaBeanUtils.toString(this.value));
            buf.append('}');
            return buf.toString();
        }
    }

    static final class Meta<T>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Integer> scenarioCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"scenarioCount", SingleScenarioArray.class, Integer.TYPE);
        private final MetaProperty<T> value = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"value", SingleScenarioArray.class, Object.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"scenarioCount", "value"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return this.scenarioCount;
                }
                case 111972721: {
                    return this.value;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SingleScenarioArray<T>> builder() {
            return new Builder();
        }

        public Class<? extends SingleScenarioArray<T>> beanType() {
            return SingleScenarioArray.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Integer> scenarioCount() {
            return this.scenarioCount;
        }

        public MetaProperty<T> value() {
            return this.value;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -1203198113: {
                    return ((SingleScenarioArray)bean).getScenarioCount();
                }
                case 111972721: {
                    return ((SingleScenarioArray)bean).getValue();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

