/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.data.scenario;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.timeseries.LocalDateDoubleTimeSeries;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.data.scenario.MarketDataBox;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.Optional;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class SingleScenarioMarketData
implements ImmutableBean,
MarketData,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ScenarioMarketData marketData;
    @PropertyDefinition
    private final int scenarioIndex;
    private static final TypedMetaBean<SingleScenarioMarketData> META_BEAN = LightMetaBean.of(SingleScenarioMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"marketData", "scenarioIndex"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static SingleScenarioMarketData of(ScenarioMarketData marketData, int scenarioIndex) {
        return new SingleScenarioMarketData(marketData, scenarioIndex);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inRange((int)this.scenarioIndex, (int)0, (int)this.marketData.getScenarioCount(), (String)"scenarioIndex");
    }

    @Override
    public LocalDate getValuationDate() {
        return this.marketData.getValuationDate().getValue(this.scenarioIndex);
    }

    @Override
    public boolean containsValue(MarketDataId<?> id) {
        return this.marketData.containsValue(id);
    }

    @Override
    public <T> T getValue(MarketDataId<T> id) {
        return this.marketData.getValue(id).getValue(this.scenarioIndex);
    }

    @Override
    public <T> Optional<T> findValue(MarketDataId<T> id) {
        Optional<MarketDataBox<MarketDataBox>> optionalBox = this.marketData.findValue(id);
        return optionalBox.map(box -> box.getValue(this.scenarioIndex));
    }

    @Override
    public Set<MarketDataId<?>> getIds() {
        return this.marketData.getIds();
    }

    @Override
    public <T> Set<MarketDataId<T>> findIds(MarketDataName<T> name) {
        return this.marketData.findIds(name);
    }

    @Override
    public Set<ObservableId> getTimeSeriesIds() {
        return this.marketData.getTimeSeriesIds();
    }

    @Override
    public LocalDateDoubleTimeSeries getTimeSeries(ObservableId id) {
        return this.marketData.getTimeSeries(id);
    }

    public static TypedMetaBean<SingleScenarioMarketData> meta() {
        return META_BEAN;
    }

    private SingleScenarioMarketData(ScenarioMarketData marketData, int scenarioIndex) {
        JodaBeanUtils.notNull((Object)marketData, (String)"marketData");
        this.marketData = marketData;
        this.scenarioIndex = scenarioIndex;
        this.validate();
    }

    public TypedMetaBean<SingleScenarioMarketData> metaBean() {
        return META_BEAN;
    }

    public ScenarioMarketData getMarketData() {
        return this.marketData;
    }

    public int getScenarioIndex() {
        return this.scenarioIndex;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SingleScenarioMarketData other = (SingleScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData) && this.scenarioIndex == other.scenarioIndex;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.scenarioIndex);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("SingleScenarioMarketData{");
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData)).append(',').append(' ');
        buf.append("scenarioIndex").append('=').append(JodaBeanUtils.toString((Object)this.scenarioIndex));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

